package com.cftech.questionnaire.core.questions.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.StringUtils;
import com.cftech.questionnaire.core.paper.model.PaperBaseEntity;
import com.cftech.questionnaire.core.paper.model.PaperLog;
import com.cftech.questionnaire.core.paper.service.PaperLogService;
import com.cftech.questionnaire.core.paper.service.PaperService;
import com.cftech.questionnaire.core.questions.model.Questions;
import com.cftech.questionnaire.core.questions.service.QuestionsService;
import org.owasp.esapi.ESAPI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.HtmlUtils;

import java.awt.print.Paper;
import java.util.List;

/**
 * Created by Ago on 2018/7/19.
 */
@RestController
@RequestMapping(value = "/mobile/auth/qustion")
public class MobileQuestionController {

    @Autowired
    private QuestionsService questionsService;

    @Autowired
    private PaperService paperService;

    @Autowired
    private PaperLogService paperLogService;

    /**
     * 问卷调查填写
     * @param activid 问卷ID
     * @return
     */
    @RequestMapping(value = "/getquest", method = {RequestMethod.GET,RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject getquest(Long activid){
        JSONObject jsonObject = new JSONObject();
        try {
            if(StringUtils.isNoneBlank(String.valueOf(activid))){
                    Conds conds = new Conds();
                   /* conds.equal("id",activid);
                    Sort sort = new Sort("create_time", OrderType.DESC);*/
                    PaperBaseEntity paper =paperService.fetchById(activid);
                    if(paper!=null){
                        jsonObject.put("errorNo",0);
                        jsonObject.put("question",HtmlUtils.htmlUnescape(paper.getQuestions()));
                        jsonObject.put("activityId",paper.getActivity_id());
                        jsonObject.put("paper_title",paper.getPaperTitle());
                        jsonObject.put("paper_title_en",paper.getPaperTitleEn());
                        jsonObject.put("content_des", ESAPI.encoder().decodeForHTML(paper.getContent_des()));
                        jsonObject.put("content_des_en", ESAPI.encoder().decodeForHTML(paper.getContent_des_en()));
                }

            }else{
                jsonObject.put("errorNo",2);
            }

        }catch (Exception e){
            e.printStackTrace();
            jsonObject.put("errorNo",1);
        }
        return  jsonObject;
    }

    /**
     * 提交问卷接口
     * @param questionAnswer
     * @return
     */
    @RequestMapping(value = "/insertpaperlog", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject insertpaperlog(String questionAnswer,String openid,String paperId){
        JSONObject jsonObject = new JSONObject();
        try {
            if(StringUtils.isNoneBlank(questionAnswer)&&StringUtils.isNoneBlank(openid)&&StringUtils.isNoneBlank(paperId)){
                Conds conds = new Conds();
                conds.equal("palyer_id",openid);
                conds.equal("paper_id",paperId);
                conds.equal("del_flag",0);
                PaperLog paperLog = paperLogService.fetchSearchByConds(conds);
                if(paperLog != null){  //此人已经填过问卷
                    jsonObject.put("errorNo",4);
                }else{
                    String str = HtmlUtils.htmlUnescape(questionAnswer);
                    questionsService.addpaperlog( str);
                    jsonObject.put("errorNo",0);
                }
            }else{
                jsonObject.put("errorNo",2);
            }
        }catch (Exception e){
            e.printStackTrace();
            jsonObject.put("errorNo",1);
        }
        return jsonObject;

    }
}
