package com.cftech.core.sql;

import com.cftech.core.scope.CondType;
import com.cftech.core.scope.LikeType;
import com.cftech.core.scope.LinkType;




/**
 * @Description: 模糊
 * @author: lisw
 * @date: 2016-8-05 上午11:56:19
 */
public class LikeCond extends Cond {

    private String param;
    private String value;

    public LikeCond(LinkType linkType, String param, LikeType likeType, String value) {
        super(CondType.LIKE, linkType);
        this.param = param;
        switch (likeType) {
        case LEFT:
            this.value = new StringBuilder("%").append(value).toString();
            break;
        case RIGHT:
            this.value = new StringBuilder(value).append("%").toString();
            break;
        case NORMAL:
            this.value = new StringBuilder("%").append(value).append("%").toString();
            break;
        default:
            this.value = value;
            break;
        }
    }

    public String getParam() {
        return param;
    }

    public String getValue() {
        return value;
    }
}
