package com.cftech.productclassify.dao;

import com.alibaba.fastjson.JSONObject;
import com.cftech.productclassify.model.*;
import com.cftech.core.generic.GenericDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
* 产品分类Mapper
*
* @author Buyj
* @date: 2020-09-22 18:06
*/
public interface ProductclassifyMapper extends GenericDao<Productclassify> {

    /**
     * 查产品分类
     * @param params
     * @return
     */
    List<Productclassify> fetchTreeByPage(Map<String, Object> params);
    /**
     *
     * @Description 商品列表展示
     * @Date 15:19 2020/10/21
     * @Param
     * @return
     **/
    List<ProductclassifyVO> productList(ProductclassifyDto productclassifyDto);
    /**
     *
     * @Description 商品分类菜单数据回填
     * @Date 15:19 2020/10/21
     * @Param
     * @return
     **/
    List<ProductMenuVO> productMenu();
    /**
     * @Author Licc
     * @Description  热门推荐
     * @Date 19:41 2020/11/2
     * @Param [appId]
     * @return com.alibaba.fastjson.JSONObject
     **/
    List<ProductVO> hotproduct();
    /**
     * @Author Licc
     * @Description  好药推荐
     * @Date 19:42 2020/11/2
     * @Param [appId]
     * @return com.alibaba.fastjson.JSONObject
     **/
    List<ProductVO> medicine();

    /**
     * 根据分类编码查分类ID
     * @param classifyNumber
     * @return
     */
    String selectIdsByNumber(String classifyNumber);

    List<ProductVO> productDosage();
}