package com.cftech.workshop.meeting.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author lisw
 * @date: 2018-06-28 15:20
 */
@Data
public class Meeting implements Serializable {

    /* 主键id */
    private Long id;
    /* 编码 */
    @ExportConfig(value = "编码", width = 100)
    private String number;
    /* 研讨会标题 */
    @ExportConfig(value = "研讨会标题", width = 100)
    private String title;
    /* 研讨会标题英文 */
    @ExportConfig(value = "研讨会标题英文", width = 100)
    private String titleEn;
    /* 封面图 */
    @ExportConfig(value = "封面图", width = 100)
    private String cover;
    /* 微信图文消息封面图 */
    @ExportConfig(value = "微信图文消息封面图", width = 100)
    private String wxCover;
    /* 活动简介 */
    @ExportConfig(value = "活动简介", width = 100)
    private String contentBriefInfo;
    private String contentBriefEnInfo;
    private  String address;
    private  String address_en;
    /* 活动开始时间 */
    @ExportConfig(value = "活动开始时间", width = 100)
    private Date startTime;
    /* 活动结束时间 */
    @ExportConfig(value = "活动结束时间", width = 100)
    private Date endTime;
    /* 二维码 */
    @ExportConfig(value = "二维码", width = 100)
    private String qrCode;
    /* 需求服务 */
    private String service;
    /* 截止日期 */
    private Date closing_date;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 创建时间 */
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;

    private String isQuestions;



    private String startTimeStr;
    private String endTimeStr;

    public Meeting() {
        this.delFlag = false;

    }

}