package com.cftech.common.use.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.common.use.model.Use;
import com.cftech.common.commondept.service.CommonDepartmentService;
import com.cftech.common.use.service.UseService;
import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.sys.security.UserUtils;
import com.cftech.sys.service.UserService;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.List;


/**
 * 通用申请单部门Controller
 * <p>
 * 权限字符串说明:
 * 查看:public static final String COMMONDEPARTMENT_VIEW = "qy:use:view"
 * 查看:public static final String COMMONDEPARTMENT_EDIT = "qy:use:edit"
 *
 * @author faye
 * @date: 2019-08-14 17:08
 */
@Slf4j
@Controller
@RequestMapping("/a/use")
public class UseController {

    public static final String USE_VIEW = "qy:use:view";
    public static final String USE_EDIT = "qy:use:edit";

    @Autowired
    private UseService useService;


    //列表页面
    @RequiresPermissions(value = USE_VIEW)
    @RequestMapping("/list")
    public String list(HttpServletRequest request, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        return "use/uselist";
    }

    //编辑页面（新增、修改）
    @RequiresPermissions(value = USE_EDIT)
    @RequestMapping("/form")
    public String form(HttpServletRequest request, String id, Model model) {
        if (!StringUtils.isEmpty(id)) {
            Use use = useService.fetchById(id);
            model.addAttribute("data", use);
        }
        return "use/useform";
    }

    //提交数据（新增、修改）
    @RequiresPermissions(value = USE_EDIT)
    @RequestMapping("/formData")
    @ResponseBody
    public JSONObject formData(Use use, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            if (use != null && use.getId() != null) {
                use.setUpdateBy(UserUtils.getUser().getId());
                useService.update(use);
                rtnJson.put("errorNo", 0);
            } else {
                use.setAccountsId(accountsId);
                use.setDelFlag(false);
                use.setAccountsId(UserUtils.getmpaccounts(request));
                use.setCreateBy(UserUtils.getUser().getId());
                use.setUpdateBy(UserUtils.getUser().getId());
                useService.save(use);
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }

    //获取列表数据
    @RequiresPermissions(value = USE_VIEW)
    @RequestMapping(value = "/listData")
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, Use use, HttpServletRequest request, String isKey) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("cd.del_flag", Constants.DEL_FLAG_0);
        conds.equal("cd.accounts_id", accountsId);
        if (!StringUtils.isEmpty(use.getSort())) {
            conds.like("cd.sort", use.getSort());
        }
        if(!StringUtils.isEmpty(use.getName())){
            conds.like("cd.name", use.getName());
        }
        Sort sort = new Sort("cd.create_time", OrderType.DESC);

        List<Use> list = useService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = useService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    //删除数据
    @RequiresPermissions(value = USE_EDIT)
    @RequestMapping("/delete")
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            useService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }

    @RequestMapping("/exportExcel")
    @RequiresPermissions(value = USE_VIEW)
    public void exportExcel(HttpServletRequest request, HttpServletResponse response,Use use) {
        Long accountId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("cd.del_flag", Constants.DEL_FLAG_0);
        conds.equal("cd.accounts_id", accountId);
        if (!StringUtils.isEmpty(use.getSort())) {
            conds.like("cd.sort", use.getSort());
        }
        if(!StringUtils.isEmpty(use.getName())){
            conds.like("cd.name", use.getName());
        }
        Sort sort = new Sort("cd.create_time", OrderType.DESC);
        List<Use> list = useService.fetchSearchByPage(conds, sort, 0, 0);
        ExcelKit.$Export(Use.class, response).toExcel(list, "促销品申请单申请用途信息");
    }

    @RequestMapping("/templateExcel")
    @RequiresPermissions(value = USE_VIEW)
    public void templateExcel(HttpServletRequest request, HttpServletResponse response) {
        ExcelKit.$Export(Use.class, response).toExcel(null, "促销品申请单申请用途信息");
    }

    @RequestMapping("/importExcel")
    @RequiresPermissions(value = USE_EDIT)
    @ResponseBody
    public JSONObject importExcel(HttpServletRequest request, MultipartFile file, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        JSONObject retJson = new JSONObject();
        if (file == null) {
            retJson.put("errorNo", "1");
            retJson.put("errorMsg", "未选择导入文件");
            return retJson;
        }
// 构造临时路径来存储上传的文件
        String uploadPath = System.getProperty("java.io.tmpdir");
        File uploadDir = new File(uploadPath);
        if (!uploadDir.exists()) {
            uploadDir.mkdir();
        }
        String fileName = file.getOriginalFilename();
        String filePath = uploadPath + File.separator + fileName;
        File storeFile = new File(filePath);
        try {
            file.transferTo(storeFile);
            ExcelKit.$Import().readExcel(storeFile, rowData -> {
                if (!StringUtils.isEmpty(rowData.get(0))) {
                    Use use = new Use();
                    use.setAccountsId(accountId);
                    use.setName(rowData.get(0));
                    use.setSort(rowData.get(1));
                    useService.save(use);
                }
            });
        } catch (IOException e) {
            log.error(e.getMessage());
        }
        retJson.put("errorNo", "0");
        retJson.put("errorMsg", "导入成功");
        return retJson;
    }

}
