package com.cftech.member.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.base.codingrule.utils.CodingruleUtils;
import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.member.model.MemberCars;
import com.cftech.member.service.MemberCarsService;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;


/**
 * Controller
 * <p>
 * 权限字符串说明:
 * 查看:public static final String MEMBERCARS_VIEW = "qy:memberCars:view"
 * 查看:public static final String MEMBERCARS_EDIT = "qy:memberCars:edit"
 *
 * @author lisw
 * @date: 2017-08-29 13:36
 */
@Slf4j
@Controller
@RequestMapping("/a/memberCars")
public class MemberCarsController {

    public static final String MEMBERCARS_VIEW = "qy:memberCars:view";
    public static final String MEMBERCARS_EDIT = "qy:memberCars:edit";

    @Autowired
    private MemberCarsService memberCarsService;
    @Autowired
    private CodingruleUtils codingruleUtils;


    //列表页面
    @RequiresPermissions(value = MEMBERCARS_VIEW)
    @RequestMapping("/list")
    public String list(HttpServletRequest request, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        return "memberCars/memberCarslist";
    }

    //编辑页面（新增、修改）
    @RequiresPermissions(value = MEMBERCARS_VIEW)
    @RequestMapping("/form")
    public String form(HttpServletRequest request, String id, Model model) {
        if (!StringUtils.isEmpty(id)) {
            MemberCars memberCars = memberCarsService.fetchById(id);
            model.addAttribute("data", memberCars);
        }
        return "memberCars/memberCarsform";
    }

    //提交数据（新增、修改）
    @RequiresPermissions(value = MEMBERCARS_EDIT)
    @RequestMapping("/formData")
    @ResponseBody
    public JSONObject formData(MemberCars memberCars, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            if (memberCars != null && memberCars.getId() != null) {
                memberCars.setUpdateBy(UserUtils.getUser().getId());
                memberCarsService.update(memberCars);
                rtnJson.put("errorNo", 0);
            } else {
                memberCars.setNumber(codingruleUtils.getNumber(accountsId, MemberCars.class.getName()));
                memberCars.setAccountsId(accountsId);
                memberCars.setDelFlag(false);
                memberCars.setAccountsId(UserUtils.getmpaccounts(request));
                memberCars.setCreateBy(UserUtils.getUser().getId());
                memberCars.setUpdateBy(UserUtils.getUser().getId());
                memberCarsService.save(memberCars);
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }

    //获取列表数据
    @RequiresPermissions(value = MEMBERCARS_VIEW)
    @RequestMapping(value = "/listData")
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, MemberCars memberCars, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("t.del_flag", Constants.DEL_FLAG_0);
        conds.equal("t.accounts_id", accountsId);
        if (!StringUtils.isEmpty(memberCars.getNumber())) {
            conds.like("t.number", memberCars.getNumber());
        }
        if (!StringUtils.isEmpty(memberCars.getPlateNumber())) {
            conds.like("t.plate_number", memberCars.getPlateNumber());
        }
        if (!StringUtils.isEmpty(memberCars.getMemberName())) {
            conds.like("member.name", memberCars.getMemberName());
        }
        Sort sort = new Sort("t.create_time", OrderType.DESC);

        List<MemberCars> list = memberCarsService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = memberCarsService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    //删除数据
    @RequiresPermissions(value = MEMBERCARS_EDIT)
    @RequestMapping("/delete")
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            memberCarsService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }

    @RequestMapping("/exportExcel")
    @RequiresPermissions(value = MEMBERCARS_VIEW)
    public void exportExcel(HttpServletRequest request, HttpServletResponse response,MemberCars memberCars) {
        Long accountId = UserUtils.getmpaccounts(request);
        Sort sort = new Sort("create_time", OrderType.ASC);
        Conds conds = new Conds();
        conds.equal("t.del_flag", 0);
        conds.equal("t.accounts_id", accountId);
        if (!StringUtils.isEmpty(memberCars.getNumber())) {
            conds.like("t.number", memberCars.getNumber());
        }
        if (!StringUtils.isEmpty(memberCars.getPlateNumber())) {
            conds.like("t.plate_number", memberCars.getPlateNumber());
        }
        if (!StringUtils.isEmpty(memberCars.getMemberName())) {
            conds.like("member.name", memberCars.getMemberName());
        }
        List<MemberCars> list = memberCarsService.fetchSearchByPage(conds, sort, 0, 0);
        ExcelKit.$Export(MemberCars.class, response).toExcel(list, "信息");
    }

    @RequestMapping("/templateExcel")
    @RequiresPermissions(value = MEMBERCARS_VIEW)
    public void templateExcel(HttpServletRequest request, HttpServletResponse response) {
        ExcelKit.$Export(MemberCars.class, response).toExcel(null, "信息");
    }



}
