package com.cftech.activity.market.sign.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 市场活动签到
 *
 * @author faye
 * @date: 2017-08-28 13:39
 */
@Data
public class Sign implements Serializable {

    /* 主键id */
    private Long id;
    /* 人员id */
    //@ExportConfig(value = "人员id", width = 100)
    private Long userid;
    /* 联系电话 */
    @ExportConfig(value = "联系电话", width = 100)
    private String phone;
    /* 姓名 */
    @ExportConfig(value = "姓名", width = 100)
    private String name;
    /* openid */
    @ExportConfig(value = "openid", width = 100)
    private String openid;
    /* 活动id */
    //ac@ExportConfig(value = "活动id", width = 100)
    private Long activityid;
    /* 报名时间 */
    @ExportConfig(value = "报名时间", width = 100)
    private Date enrollTime;
    /* 签到时间 */
    @ExportConfig(value = "签到时间", width = 100)
    private Date signTime;

    private Long storeid;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 创建时间 */
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;

    public Sign() {
        this.delFlag = false;
        this.status = "0";
    }

}