package com.cftech.activity.market.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 市场活动
 *
 * @author faye
 * @date: 2017-08-25 10:36
 */
@Data
public class Market implements Serializable {

    /* 主键id */
    private Long id;
    /* 编码 */
    @ExportConfig(value = "编码", width = 100)
    private String number;
    /* 名称 */
    @ExportConfig(value = "名称", width = 100)
    private String name;
    /* 活动说明 */
    @ExportConfig(value = "活动说明", width = 100)
    private String explains;
    /* 活动归属 0 集团  1 品牌 2门店 */
    @ExportConfig(value = "活动归属 0 集团  1 品牌 2门店", width = 100)
    private String belong;
    /* 活动类型 0普通告知类 1报名支付 */
    @ExportConfig(value = "活动类型 0普通告知类 1报名支付", width = 100)
    private String type;

    private String price;//支付金额

    /* 活动详情 */
    @ExportConfig(value = "活动详情", width = 100)
    private String content;
    /* 门店id */

    private Long storeid;
    @ExportConfig(value = "门店", width = 100)
    private String storeName;
    /* 品牌id */
    private String brandid;
    @ExportConfig(value = "品牌", width = 100)
    private String brandName;
    /* 签到二维码 */
    @ExportConfig(value = "签到二维码", width = 100)
    private String qrcode;
    /* 活动开始时间 */
    @ExportConfig(value = "活动开始时间", width = 100)
    private Date actstarttime;
    /* 活动结束时间 */
    @ExportConfig(value = "活动结束时间", width = 100)
    private Date actendtime;
    /* 报名开始时间 */
    @ExportConfig(value = "报名开始时间", width = 100)
    private Date signstarttime;
    /* 报名结束时间 */
    @ExportConfig(value = "报名结束时间", width = 100)
    private Date signendtime;
    /* 活动小图 */
    @ExportConfig(value = "活动小图", width = 100)
    private String smallimg;
    /* 活动大图 */
    @ExportConfig(value = "活动大图", width = 100)
    private String img;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 创建时间 */
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;

    private String cardName;//卡券名称

    private Long cardid;

    public Market() {
        this.delFlag = false;
        this.status = "0";
    }

}