package com.cftech.cos.uploader.category.service;

import com.cftech.core.generic.GenericService;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.cos.uploader.category.model.MaterialCategory;

import java.util.List;

/**
* 问卷分类Service
*
* @author Neil
* @date: 2017-05-23 13:24
*/
public interface MaterialCategoryService extends GenericService<MaterialCategory> {

    List<MaterialCategory> fetchSearchByPage(Long parentId, Conds conds, Sort sort, int page, int pageSize);

    List<MaterialCategory> fetchTreeByPage(Conds conds, Sort sort, int page, int pageSize);

    int count(Long parentId, Conds conds);

    /**
     * 删除分类以及对应分类下图片
     * @param id
     */
    void deleteAndFile(String id);
}
