package com.cftech.cos.config.cosconfig.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 云存储设置
 *
 * @author Neil
 * @date: 2017-05-02 16:35
 */
@Data
public class Cosconfig implements Serializable {

    /* 主键id */
    private Long id;

    /* 云存储的类型 */
    @ExportConfig(value = "云存储的类型", width = 100)
    private String cosType;
    /* APPID */
    @ExportConfig(value = "APPID", width = 100)
    private Long appId;
    /* 云存储的Key */
    @ExportConfig(value = "云存储的Key", width = 100)
    private String keyId;
    /* 云存储的Secret */
    @ExportConfig(value = "云存储的Secret", width = 100)
    private String keySecret;
    /* Bucket */
    @ExportConfig(value = "Bucket", width = 100)
    private String bucket;
    /* endpoint */
    @ExportConfig(value = "endpoint", width = 100)
    private String endpoint;
    /* bucket的区域 */
    @ExportConfig(value = "region", width = 100)
    private String region;
    /* 访问的基础链接 */
    @ExportConfig(value = "url", width = 100)
    private String url;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 创建时间 */
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;

    public Cosconfig() {
        this.delFlag = false;
        this.status = "0";
    }

}