package com.cftech.order.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.core.sql.Conds;
import com.cftech.core.util.Constants;
import com.cftech.invoice.model.InvoiceDto;
import com.cftech.order.model.Order;
import com.cftech.order.model.OrderMobileDto;
import com.cftech.order.service.OrderService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @author ：licc
 * @date ：Created in 2020/10/30 15:40
 * @description：
 */
@Slf4j
@RestController
@CrossOrigin
@RequestMapping("mobile/auth/order")
public class MobileOrderController {

    @Autowired
    private OrderService orderService;

    /**
     * @return
     * @Author Licc
     * @Description 订单信息
     * @Date 15:43 2020/10/30
     * @Param
     **/
    @RequestMapping(value = "/confirm", method = {RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject confirm(OrderMobileDto orderMobileDto) {
        return orderService.confirm(orderMobileDto);
    }

    /**
     * @return
     * @Author Licc
     * @Description 个人中心订单统计
     * @Date 19:03 2020/11/3
     * @Param
     **/
    @RequestMapping(value = "/orderSize", method = {RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject orderSize(String openId,String appId) {
        return orderService.orderSize(openId, appId);
    }

    /**
     * @return
     * @Author Licc
     * @Description 根据搜索条件查询订单
     * @Date 19:40 2020/11/3
     * @Param
     **/
    @RequestMapping(value = "/orderList", method = {RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject orderList(OrderMobileDto orderMobileDto) {
        return orderService.orderList(orderMobileDto);
    }

    /**
     * 开票接口
     * @Author BuYJ
     * @param invoiceDto
     * @return
     */
    @RequestMapping(value = "/invoice", method = {RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject invoice(InvoiceDto invoiceDto){
        return orderService.invoice(invoiceDto);
    }

    /**
     * 订单回调方法
     * @return
     */
    @RequestMapping(value = "/wechatCallback", method = {RequestMethod.POST, RequestMethod.GET})
    public String wechatCallback(HttpServletRequest request) {
        log.info(" wechatCallback   已触发微信付款回调！");
        return orderService.callBackPayStatus(request);
    }

    /**
     * 获取微信付款加密参数
     * @param orderId
     * @param openId
     * @param appId
     * @param prepayId
     * @return
     */
    @RequestMapping(value = "/findOrderPayParams", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public String findOrderPayParams(@RequestParam String orderId,
                                     @RequestParam String openId,
                                     @RequestParam String appId,
                                     @RequestParam String prepayId) {
        return orderService.findOrderPayParams(orderId, openId, appId, prepayId);
    }

    /**
     * 获取路由信息
     * @param appId
     * @param orderCode
     * @return
     */
    @RequestMapping(value = "/findRouteDetails", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject findRouteDetails(@RequestParam String appId,
                                   @RequestParam String orderCode) {
        return orderService.findRouteDetails(appId, orderCode);
    }

}
