package com.cftech.order.job;

import com.cftech.accounts.model.SysJob;
import com.cftech.accounts.service.JobService;
import com.cftech.accounts.service.JobTask;
import com.cftech.accounts.service.RedisSubPubListener;
import com.cftech.base.codingrule.service.CodingruleService;
import com.cftech.core.sql.Conds;
import com.cftech.core.util.DESUtil;
import com.cftech.core.util.SpringContextHolder;
import com.cftech.core.util.SystemConfig;
import lombok.extern.slf4j.Slf4j;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.text.SimpleDateFormat;
import java.util.List;

/**
 * Created by 16444 on 2021/1/4.
 */
@Slf4j
public class InitAliasNumberJob implements Job {

    @Override
    public void execute(JobExecutionContext context) throws JobExecutionException {
        boolean isCluster = Boolean.valueOf(SystemConfig.p.getProperty("quartz.isCluster"));
        if (!isCluster) {
            return;
        }

        //获得明细数据
        JobDataMap jobInfo = context.getJobDetail().getJobDataMap();
        String id = jobInfo.get("uid") == null ? "" : jobInfo.getString("uid");//这个也是ID主键
        log.info("任务ID：" + id);

        JobService jobService = SpringContextHolder.getBean(JobService.class);
        Conds conds = new Conds();
        conds.equal("clazz_path","com.cftech.order.job.InitAliasNumberJob");
        conds.equal("del_flag",0);
        SysJob job = jobService.fetchSearchByConds(conds);
        job.setDescription("1");//重置别名
        jobService.update(job);


        //执行更新操作
        if (context.getNextFireTime() != null) {
            log.info("初始化别名key任务：下次执行时间=====" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(context.getNextFireTime()) + "==============");
        } else {
            SysJob sysJob = new SysJob();
            sysJob.setJobuid(id);
            sysJob.setStatus("0");
            jobService.updateStatus(sysJob);
            log.info("初始化别名key任务，已执行完成！");
        }
    }
}
