package com.cftech.logistics.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 物流信息
 *
 * @author Buyj
 * @date: 2020-11-29 17:19
 */
@Data
public class Logistics implements Serializable {

    /** 主键id */
    private Long id;
    /** 顺风运单号 */
    @ExportConfig(value = "顺丰运单号", width = 100, showLevel = 1)
    private String mailNo;
    /** 订单号 */
    @ExportConfig(value = "订单号", width = 100, showLevel = 1)
    private String orderNo;
    /** 路由节点发生时间 */
    @ExportConfig(value = "路由节点发生时间", width = 100, showLevel = 1)
    private Date acceptTime;
    /** 物流编码 */
    @ExportConfig(value = "物流编码", width = 100, showLevel = 1)
    private String number;
    /** 路由节点发生地 */
    @ExportConfig(value = "路由节点发生地", width = 100, showLevel = 1)
    private String acceptAddress;
    /** 路由节点操作码 */
    @ExportConfig(value = "路由节点操作码", width = 100, showLevel = 1)
    private String opcode;
    /** 所属的账号 */
    private Long accountsId;
    /** 删除标识 */
    private boolean delFlag;
    /** 状态 */
    private String status;
    /** 创建时间 */
    private Date createTime;
    /** 更新时间 */
    private Date updateTime;
    @ExportConfig(value = "路由节点描述", width = 100, showLevel = 1)
    private String description;
    /** 创建人 */
    private Long createBy;
    /** 更新人 */
    private Long updateBy;
    /** 顺丰发件时间 */
    private String sendExpressDate;

    public Logistics() {
        this.delFlag = false;
        this.status = "0";
    }

}