package com.cftech.invoice.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.invoice.model.InvoiceDetail;
import com.cftech.invoice.service.InvoiceService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Slf4j
@RequestMapping("mobile/data/invoice")
public class MobileInvoiceController {

    @Autowired
    private InvoiceService invoiceService;

    /**
     * 查看发票详情接口
     * @param invoiceDetail (传订单ID  和appId)
     * @return
     */
    @RequestMapping(value = "/invoiceDetail", method = {RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject invoiceDetail (InvoiceDetail invoiceDetail){
        return invoiceService.selectInvoiceDetail(invoiceDetail);
    }

    /**
     * 通过openid获取已填写邮箱
     * @param openid
     * @return
     */
    @RequestMapping(value = "/findFassDefaultEmail", method = {RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject findFassDefaultEmail(@RequestParam String openid) {
        return invoiceService.findFassDefaultEmail(openid);
    }

    /**
     * 重新发送邮箱
     * @param appId
     * @param invoiceId
     * @param openId
     * @param email
     * @return
     */
    @RequestMapping(value = "/sendEmail", method = {RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject sendEmail(@RequestParam String appId, @RequestParam String invoiceId, @RequestParam String openId, @RequestParam String email) {
        return invoiceService.sendEmail(appId, openId, invoiceId, email);
    }
}
