package com.cftech.invoice.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 开票信息
 *
 * @author Buyj
 * @date: 2020-11-25 09:32
 */
@Data
public class Invoice implements Serializable {

    /** 主键id */
    private Long id;
    private String number;
    /** 发票抬头 */
    @ExportConfig(value = "发票抬头", width = 100, showLevel = 1)
    private String invoiceTitle;
    /** 发票内容 */
    @ExportConfig(value = "发票内容", width = 100, showLevel = 1)
    private String invoiceContent;
    /** 单位税号 */
    @ExportConfig(value = "单位税号", width = 100, showLevel = 1)
    private String unitTaxNumber;
    /** 发票类型（1：蓝票，2红票） */
    @ExportConfig(value = "发票类型", width = 100, showLevel = 1)
    private String invoiceType;
    /** 来源（0:移动端 1：后台） */
    @ExportConfig(value = "来源", width = 100, showLevel = 1)
    private String invoiceForm;
    /** 开票人id(移动端传opendId，后台传userid) */
    @ExportConfig(value = "开票人", width = 100, showLevel = 1)
    private String clerkId;
    /** 订单ID */
    @ExportConfig(value = "订单编码", width = 100, showLevel = 1)
    private String orderId;
    /** 推送方式（0:邮箱） */
    @ExportConfig(value = "推送方式", width = 100, showLevel = 1)
    private String pushMode;
    /** 推送邮箱 */
    @ExportConfig(value = "推送邮箱", width = 100, showLevel = 1)
    private String email;
    /** 发票流水号 */
    @ExportConfig(value = "发票流水号", width = 100, showLevel = 1)
    private String invoiceSerialNum;
    /** 商品ID 逗号隔开 */
    private String productId;
    /** 所属的账号 */
    private Long accountsId;
    /** 删除标识 */
    private boolean delFlag;
    /** 状态 */
    /**
     * 状态( 0:个人  1:企业 )
     */
    @ExportConfig(value = "抬头类型")
    private String status;
    /** 创建时间 */
    private Date createTime;
    /** 更新时间 */
    private Date updateTime;
    /** 备注 */
    private String description;
    /** 创建人 */
    private Long createBy;
    /** 更新人 */
    private Long updateBy;
    /**
     * openId
     */
    private String openId;
    /**
     * 操作者
     */
    private String operator;

    //发票代码
    private String invoiceCode;

    //发票号码
    private String invoiceNum;

    public Invoice() {
        this.delFlag = false;
        this.status = "0";
    }

}