import request from '@/utils/request';

enum Api {
  listUrl = '/sys/User/list',
  saveUrl = '/sys/User/save',
  deleteUrl = '/sys/User/delete/',
  viewUrl = '/sys/User/view/',
  settingPwdUrl = '/sys/User/settingPwd',
  changeEnableUrl = '/sys/User/changeEnable',
  onlinelistUrl = '/sys/onlineUser/list',
  kickOutUserUrl = '/sys/onlineUser/kickOutUser/',
  uploadPhotoUrl = '/sys/User/uploadPhoto',
  updatePasswordUrl = '/sys/User/updatePwd'
}
export function kickOutUser(token) {
  return request({
    url: Api.kickOutUserUrl + token,
    method: 'GET',
  });
}
export function onlinelist(params) {
  return request({
    url: Api.onlinelistUrl,
    method: 'POST',
    data: params,
  });
}
export function settingPwd(params) {
  return request({
    url: Api.settingPwdUrl,
    method: 'POST',
    data: params,
  });
}
export function uploadPhoto(params) {
  return request({
    url: Api.uploadPhotoUrl,
    method: 'POST',
    data: params,
  });
}

export function changeEnable(params) {
  return request({
    url: Api.changeEnableUrl,
    method: 'POST',
    data: params,
  });
}
export function deleteData(id) {
  return request({
    url: Api.deleteUrl + id,
    method: 'DELETE',
  });
}
export function view(id) {
  return request({
    url: Api.viewUrl + id,
    method: 'GET',
  });
}
export function getListData(params) {
  return request({
    url: Api.listUrl,
    method: 'POST',
    data: params,
  });
}

export function save(params) {
  return request({
    url: Api.saveUrl,
    method: 'PUT',
    data: params,
  });
}

/**
 * 修改密码
 */
export function updatePwd(data) {
  return request({
    url: Api.updatePasswordUrl,
    method: 'POST',
    data: data,
  });
}
