import { TableColumnSchema, FormSchema } from 'link-components';
import { createOpenTitle, createSwitch } from '@/views/common/utils';

export function listColumns(showDetail: Function,handleChangeStatus: Function): TableColumnSchema[]{
  return [
    {type: 'seq',title: '序号', width: 60},
    {
      title: '参数编码',
      field: 'code',
      query: {
        colProps: 5,
        component: 'Input',
      },
      width: 200,
      renderCustom: ({ row }) => {
        return createOpenTitle(showDetail,row,'code');
      }
    },
    {
      title: '参数名称',
      field: 'name',
      query: {
        colProps: 5,
        component: 'Input',
      },
      sortable: true,
      width: 200,
      align: 'left',
    },
    {
      title: '参数值',
      field: 'value',
      width: 300,
    },
    {
      title: '状态',
      field: 'isEnable',
      query: {
        colProps: 8,
        component: 'RadioGroup',
        componentProps: {
          options: [{
            label: '全部',
          },{
            label: '启用',
            value: 1
          },{
            label: '禁用',
            value: 0
          }]
        }
      },
      width: 90,
      renderCustom: ({ row }) => {
        return createSwitch(handleChangeStatus, row);
      }
    },
    {
      title: '备注',
      field: 'remake',
    }
  ];
}

export const formSchema: FormSchema[] = [
  {
    field: 'id',
    title: 'id',
    component: 'Input',
    show: false,
  },
  {
    field: 'code',
    title: '参数编码',
    component: 'Input',
    required: true,
  },
  {
    field: 'name',
    title: '参数名称',
    component: 'Input',
    required: true,
  },
  {
    field: 'isEnable',
    title: '状态',
    required: true,
    component: 'RadioGroup',
    componentProps: {
      options: [
        { label: '启用', value: 1 },
        { label: '禁用', value: 0 },
      ],
    },
  },
  {
    field: 'value',
    title: '参数值',
    component: 'Input',
    required: true,
    componentProps: {
      type: 'textarea',
      autosize: { minRows: 5}
    }
  },
  {
    field: 'remake',
    title: '备注',
    component: 'Input',
    componentProps: {
      type: 'textarea'
    }
  },
];

