import {FormSchema, TableColumnSchema} from 'link-components';
import {createOpenTitle, createSwitch} from '@/views/common/utils';

export function listColumns(showDetail: Function,handleChangeStatus: Function): TableColumnSchema[]{
  return [
    {type: 'seq',title: '序号', width: 70},
    {
      title: 'parentId',
      field: 'parentId',
      visible: false,
    },
    {
      title: '组织编码',
      field: 'code',
      width: 100,
      renderCustom: ({ row }) => {
        return createOpenTitle(showDetail,row,'code');
      }
    },
    {
      title: '组织名称',
      treeNode: true,
      field: 'name',
      width: 200,
    },
    {
      title: '是否启用',
      field: 'isEnable',
      sortable: true,
      width: 100,
      renderCustom: ({ row }) => {
        return createSwitch(handleChangeStatus, row);
      }
    },
    {
      title: '排序号',
      field: 'orderNumber',
      width: 100,
    },
    {
      title: '备注',
      field: 'remake',
    },
  ];
}

export function formSchema(getOrgTreeData: any): FormSchema[]{
  return [
    {
      field: 'id',
      title: 'id',
      component: 'Input',
      show: false,
    },
    {
      field: 'code',
      title: '组织编码',
      required: true,
      component: 'Input',
    },
    {
      field: 'name',
      title: '组织名称',
      required: true,
      component: 'Input',
    },
    {
      field: 'orderNumber',
      title: '排序号',
      colProps: 12,
      component: 'Input',
    },
    {
      field: 'isEnable',
      title: '状态',
      component: 'RadioGroup',
      colProps: 24,
      required: true,
      componentProps: {
        options: [
          { label: '启用', value: 1 },
          { label: '禁用', value: 0 },
        ],
      },
    },
    {
      field: 'parentId',
      title: '上级组织',
      component: 'TreeSelect',
      componentProps:{
        api: getOrgTreeData,
        props: {
          value: 'id',
          label: 'name',
        },
        filterable: true,
        clearable: true,
      }
    },
    {
      field: 'remake',
      title: '备注',
      component: 'Input',
      componentProps: {
        type: 'textarea',
        autosize: { minRows: 5}
      }
    },
  ]
}

