import { TableColumnSchema, FormSchema } from 'link-components';
import { h } from 'vue';
import { ElTag } from 'element-plus'
import SvgIcon from '@/components/SvgIcon/index.vue'
import { createOpenTitle, createSwitch } from '@/views/common/utils';

export function listColumns(showDetail: Function,handleChangeStatus: Function): TableColumnSchema[]{
  return [
    {type: 'seq',title: '序号', width: 70},
    {
      title: 'parentId',
      field: 'parentId',
      visible: false,
    },
    {
      title: '菜单标题',
      field: 'title',
      treeNode: true,
      sortable: true,
      width: 200,
      align: 'left',
    },
    {
      title: '菜单标识',
      field: 'code',
      sortable: true,
      width: 200,
      renderCustom: ({ row }) => {
        return createOpenTitle(showDetail,row,'code');
      }
    },
    {
      title: '是否启用',
      field: 'isEnable',
      sortable: true,
      width: 100,
      renderCustom: ({ row }) => {
        return createSwitch(handleChangeStatus, row);
      }
    },
    {
      title: '排序号',
      field: 'orderNumber',
      sortable: true,
      width: 100,
    },
    {
      title: '超链接菜单?',
      field: 'isLink',
      width: 100,
      align: 'left',
      renderCustom: ({ row }) => {
          const enable = row.isLink === 1;
          const text = enable ? '是' : '否';
          return h(ElTag, { }, () => text);
      },
    },
    {
      title: '图标',
      field: 'icon',
      sortable: true,
      width: 100,
      align: 'left',
      showOverflow: "ellipsis"
    },
    {
      title: '路径',
      field: 'path',
      sortable: true,
      width: 100,
      align: 'left',
      showOverflow: "ellipsis"
    },
    {
      title: '菜单类型',
      field: 'menuType',
      width: 100,
      renderCustom: ({ row }) => {
        return h(ElTag, { }, () => row.menuType === 'menu'?'菜单':'权限项');
    },
    },
    {
      title: '权限标识',
      field: 'permissionTag',
      sortable: true,
      showOverflow: "ellipsis",
      minWidth: 100,
      align: 'left',
    },
  ];
}

export const formSchema: FormSchema[] = [
  {
    field: 'id',
    title: 'id',
    component: 'Input',
    show: false,
  },
  {
    field: 'dataVersion',
    title: 'dataVersion',
    component: 'Input',
    show: false,
  },
  {
    field: 'menuType',
    title: '菜单类型',
    component: 'RadioGroup',
    colProps: 24,
    required: true,
    componentProps:{
      options: [
        {label: '菜单', value: 'menu'},
        {label: '权限项', value: 'button'},
      ]
    }
  },
  {
    field: 'title',
    title: '菜单标题',
    component: 'Input',
    required: true,
    colProps: 24,
  },
  {
    field: 'parentId',
    title: '上级菜单',
    colProps: 24,
    component: 'BindDict',
    componentProps: {
      type: 'TreeSelect',
      billVo: 'com.link.jiandanbiao.sys.vo.MenuVo',
      fields: 'id,title',
      dynFilter: "is_enable = 1 and menu_type='menu'",
      serviceName: 'link-system-start',
      filterable: true,
      clearable: true,
      props: {
        label: 'title',
        value: 'id',
      }
    }
  },
  {
    field: 'orderNumber',
    title: '排序号',
    component: 'InputNumber',
    required: true,
    colProps: 24,
  },
  {
    field: 'isEnable',
    title: '状态',
    component: 'RadioGroup',
    componentProps: {
      options: [
        { label: '启用', value: 1 },
        { label: '禁用', value: 0 },
      ],
    },
  },
  {
    field: 'isHide',
    title: '隐藏菜单？',
    component: 'RadioGroup',
    componentProps: {
      options: [
        { label: '显示', value: 0 },
        { label: '隐藏', value: 1 },
      ],
    },
  },
  {
    field: 'code',
    title: '菜单标识',
    component: 'Input',
    required: true,
    colProps: 24,
  },
  {
    field: 'path',
    title: '路径',
    helpMessage: '如果为根目录请填写Layout 否则会引起展现异常，当为内嵌窗口或超链接菜单时此处应该填写http地址',
    component: 'Input',
    slot: 'path',
    colProps: 24,
    show: ({values})=> 'menu' === values.menuType,
  },
  {
    field: 'icon',
    title: '图标',
    show: ({values})=> 'menu' === values.menuType,
    component: 'IconSelect',
  },
  {
    field: 'permissionTag',
    title: '权限标识',
    show: ({values})=> 'menu' === values.menuType,
    component: 'Input',
  },
  {
    field: 'isLink',
    title: '超链接菜单',
    component: 'RadioGroup',
    show: ({values})=> 'menu' === values.menuType,
    componentProps: {
      options: [
        { label: '是', value: 1 },
        { label: '否', value: 0 },
      ],
    },
  },
  {
    field: 'isKeepAlive',
    title: '是否缓存',
    component: 'RadioGroup',
    show: ({values})=> 'menu' === values.menuType,
    componentProps: {
      options: [
        { label: '是', value: 1 },
        { label: '否', value: 0 },
      ],
    },
  },
  {
    field: 'isAffix',
    title: '是否固定',
    component: 'RadioGroup',
    show: ({values})=> 'menu' === values.menuType,
    componentProps: {
      options: [
        { label: '是', value: 1 },
        { label: '否', value: 0 },
      ],
    },
  },
  {
    field: 'isIframe',
    title: '是否内嵌窗口',
    component: 'RadioGroup',
    show: ({values})=> 'menu' === values.menuType,
    componentProps: {
      options: [
        { label: '是', value: 1 },
        { label: '否', value: 0 },
      ],
    },
  }
];

export const tableSchemaE1: TableColumnSchema[] = [
  {
    title: '路由标题',
    field: 'title',
    width: 130,
    required: true,
    editRender: {
      component: 'Input',
    }
  },
  {
    title: '路由名称',
    field: 'code',
    width: 130,
    required: true,
    editRender: {
      component: 'Input',
    }
  },
  {
    title: '路径',
    field: 'path',
    width: 200,
    required: true,
    editRender: {
      component: 'Input',
    }
  },
  {
    title: '是否启用',
    field: 'isEnable',
    width: 100,
    editRender: {
      component: 'Switch',
      componentProps: {
        activeValue: 1,
        inactiveValue: 0,
      }
    },
    renderCustom: ({row})=>{
      return h(ElTag, { type: 1 === row.isEnable?"success":"danger"}, () =>  1 === row.isEnable? '启用': '禁用');
    },
  },
  {
    title: '图标',
    field: 'icon',
    width: 140,
    editRender: {
      component: 'IconSelect',
    },
    renderCustom: ({row})=>{
      return h(SvgIcon, { name: row.icon});
    },
  },
  {
    title: '是否缓存',
    field: 'isKeepAlive',
    width: 100,
    editRender: {
      component: 'Switch',
      componentProps: {
        activeValue: 1,
        inactiveValue: 0,
      }
    },
    renderCustom: ({row})=>{
      return h(ElTag, { type: 1 === row.isKeepAlive?"success":"danger"}, () =>  1 === row.isKeepAlive? '启用': '禁用');
    },
  },
]
