import { TableColumnSchema, FormSchema } from 'link-components';
import {createSwitch } from '@/views/common/utils';

export function listColumns(_showDetail: Function, handleChangeStatus: Function): TableColumnSchema[]{
  return [
    {type: 'seq',title: '序号', width: 60},
    {field: 'parentId',title: '上级ID', visible: false},
    {
      title: '分类名称',
      field: 'name',
      sortable: true,
      width: 150,
      query: true,
      resizable: true,
      treeNode: true
    },
    {
      title: '编号',
      field: 'code',
      sortable: true,
      resizable: true,
      width: 150,
    },
    {
      title: '是否启用',
      field: 'isEnable',
      sortable: true,
      width: 100,
      renderCustom: ({ row }) => {
        return createSwitch(handleChangeStatus, row);
      }
    },
    {
      title: '最后更新人',
      field: 'lastUpdateUserId_alias',
      width: 120,
      align: 'left',
    },
    {
      title: '最后更新时间',
      field: 'lastUpdateTime',
      sortable: true,
      width: 170,
      align: 'left',
    }
  ];
}

export const formSchema: FormSchema[] = [
  {
    field: 'id',
    title: 'id',
    component: 'Input',
    show: false,
  },
  {
    field: 'dataVersion',
    title: 'dataVersion',
    component: 'Input',
    show: false,
  },
  {
    field: 'code',
    title: '编码',
    required: true,
    component: 'Input',
  },
  {
    field: 'name',
    title: '名称',
    required: true,
    component: 'Input',
  },
  {
    field: 'parentId',
    title: '上级',
    component: 'BindDict',
    componentProps: {
      type: 'TreeSelect',
      filterable: true,
      clearable: true,
      billVo: 'com.link.jiandanbiao.bpm.core.vo.WfTypeVo',
      fields: 'name,id,parentId',
      serviceName: 'link-bpm-start',
      props: {
        label: 'name',
        value: 'id'
      }
    }
  },
  {
    field: 'isEnable',
    title: '状态',
    component: 'RadioGroup',
    required: true,
    componentProps: {
      options: [
        { label: '启用', value: 1 },
        { label: '禁用', value: 0 },
      ],
    },
  },
];


