import request from '@/utils/request';
import {guid} from '@/utils/commonFunction'
enum Api {
  listUrl = '/sys/Position/list',
  saveUrl = '/sys/Position/save',
  deleteUrl = '/sys/Position/delete/',
  viewUrl = '/sys/Position/view/',
  changeEnableUrl = '/sys/Position/changeEnable',
  getPositionTreeDataUrl = '/sys/Position/getPositionTreeData',
  getOrgPositionTreeDataUrl = '/sys/Position/getOrgPositionTreeData',
}
export function getOrgPositionTreeData() {
  return request({
    url: Api.getOrgPositionTreeDataUrl,
    method: 'GET',
  });
}
export function getPositionTreeData() {
  return request({
    url: Api.getPositionTreeDataUrl,
    method: 'GET',
  });
}
export function changeEnable(params) {
  return request({
    url: Api.changeEnableUrl,
    method: 'POST',
    data: params,
  });
}
export function deleteData(id) {
  return request({
    url: Api.deleteUrl + id,
    method: 'DELETE',
  });
}
export function view(id) {
  return request({
    url: Api.viewUrl + id,
    method: 'GET',
  });
}
export function getListData(params) {
  return request({
    url: Api.listUrl,
    method: 'POST',
    data: params,
  });
}

export function save(params) {
  return request({
    url: Api.saveUrl,
    method: 'PUT',
    data: params,
  });
}

export function getId() {
  return 'RCGZT' + guid();
}
