import request from '@/utils/request';

enum Api {
  listUrl = '/job/Schedu/list',
  saveUrl = '/job/Schedu/save',
  deleteUrl = '/job/Schedu/delete/',
  viewUrl = '/job/Schedu/view/',
  runUrl = '/job/Schedu/run/',
  pauseUrl = '/job/Schedu/pause/',
  resumeUrl = '/job/Schedu/resume/',
}
export function pause(id) {
  return request({
    url: Api.pauseUrl + id,
    method: 'GET',
  });
}
export function resume(id) {
  return request({
    url: Api.resumeUrl + id,
    method: 'GET',
  });
}
export function run(id) {
  return request({
    url: Api.runUrl + id,
    method: 'GET',
  });
}
export function deleteData(id) {
  return request({
    url: Api.deleteUrl + id,
    method: 'DELETE',
  });
}
export function view(id) {
  return request({
    url: Api.viewUrl + id,
    method: 'GET',
  });
}
export function getListData(params) {
  return request({
    url: Api.listUrl,
    method: 'POST',
    data: params,
  });
}

export function save(params) {
  return request({
    url: Api.saveUrl,
    method: 'PUT',
    data: params,
  });
}

