import { TableColumnSchema, FormSchema } from 'link-components';
import { h } from 'vue';
import { ElButton, ElTag } from 'element-plus'
import { viewWfProcessChart } from '@/views/common/utils';

export function listColumns(_showDetail: Function, _handleChangeStatus: Function): TableColumnSchema[]{
  return [
    {type: 'seq',title: '序号', width: 60},
    {
      title: '状态',
      field: 'orderState_alias',
      hide: true
    },
    {
      title: '状态',
      field: 'orderState',
      width: 120,
      renderCustom: ({row}) => {
        if('Suspended'===row.orderState){
          return h(ElButton,{type: 'danger', size: 'small', onClick: ()=>{
              _showDetail(row);
            }}, '已挂起>查看日志')
        }
        let stateType = 'primary';
        if('Active' === row.orderState){
          stateType = 'primary';
        }
        if('Cancelled' === row.orderState){
          stateType = 'info';
        }
        if('Suspended' === row.orderState){
          stateType = 'danger';
        }
        if('Stop' === row.orderState){
          stateType = 'warning';
        }
        // @ts-ignore
        return h(ElTag,{type: stateType}, {
          default: () => row.orderState_alias
        })
      },
      query: {
        component: 'Select',
        componentProps: {
          clearable: true,
          options: [
            {
              label: '运行中',
              value: 'Active'
            },
            {
              label: '撤销',
              value: 'Cancelled'
            },
            {
              label: '挂起',
              value: 'Suspended'
            },
            {
              label: '终止',
              value: 'Stop'
            }
          ],
          props: {
            label: 'label',
            value: 'value',
          }
        }
      },
    },
    {
      title: '流程图',
      field: 'process_view',
      width: 100,
      renderCustom: ({row})=>{
        return viewWfProcessChart(row.id);
      }
    },
    {
      title: '发起人',
      field: 'creatorId_alias',
      width: 100,
      query: true
    },
    {
      title: '实例ID',
      field: 'id',
      width: 200,
      showOverflow: 'tooltip',
      resizable: true,
      query: true
    },
    {
      title: '单据ID',
      field: 'billId',
      width: 100,
      query: true,
      showOverflow: 'tooltip',
      resizable: true
    },
    {
      title: '版本',
      field: 'version',
      width: 100,
      sortable: true
    },
    {
      title: '创建时间',
      field: 'createTime',
      width: 170,
      sortable: true
    },
    {
      title: '完成时间',
      field: 'finishTime',
      width: 170,
      sortable: true
    },
    {
      title: '错误日志',
      field: 'wfOrderErrorLog',
      slot: 'wfOrderErrorLog',
      width: 150,
      visible: false,
    },
  ];
}

export const errorLogFormSchema: FormSchema[] = [
  {
    field: 'logTitle',
    title: '日志标题',
    component: 'Input',
    colProps: 24,
    componentProps: {
      readonly: true,
    }
  },
  {
    field: 'errorTime',
    title: '错误发生时间',
    component: 'Input',
    colProps: 24,
    componentProps: {
      readonly: true,
    }
  },
  {
    field: 'errorMessage',
    title: '错误日志',
    component: 'Input',
    colProps: 24,
    componentProps: {
      readonly: true,
      type: 'textarea',
    }
  },
];

