import type { App } from 'vue';
import { usePermission } from '@/hooks/web/usePermission';

/**
 * 用户权限指令
 * @directive 多个权限验证，满足一个则显示（v-permission="[xxx]"）
 * @directive 多个权限验证，全部满足则显示（v-permission-all="[xxx,xxx]"）
 */
export default function (app: App) {
  const {hasPermission, hasPermissionAll} = usePermission();
	// 多个权限验证，满足一个则显示（v-permission="[xxx,xxx]"）
	app.directive('permission', {
		mounted(el, binding) {
			if (!hasPermission(binding.value)) el.parentNode.removeChild(el);
		},
	});
	// 多个权限验证，全部满足则显示（v-permission-all="[xxx,xxx]"）
	app.directive('permission-all', {
		mounted(el, binding) {
			if (!hasPermissionAll(binding.value)) el.parentNode.removeChild(el);
		},
	});
}
