import request from '@/utils/request';

enum Api {
  listUrl = '/sys/Dict/list',
  saveUrl = '/sys/Dict/save',
  deleteUrl = '/sys/Dict/delete/',
  viewUrl = '/sys/Dict/view/',
  changeEnableUrl = '/sys/Dict/changeEnable',
  getDictGroupTreeDataUrl = '/sys/Dict/getDictGroupTreeData',
  getDictTreeDataUrl = '/sys/Dict/getDictTreeData',
  saveDictUrl = '/sys/Dict/saveDict',
  viewDictUrl = '/sys/Dict/viewDict/',
  deleteDictUrl = '/sys/Dict/deleteDict/'
}
export function getDictTreeData() {
  return request({
    url: Api.getDictTreeDataUrl,
    method: 'GET',
  });
}
export function saveDict(params) {
  return request({
    url: Api.saveDictUrl,
    method: 'PUT',
    data: params,
  });
}
export function deleteDict(id) {
  return request({
    url: Api.deleteDictUrl + id,
    method: 'DELETE',
  });
}
export function viewDict(id) {
  return request({
    url: Api.viewDictUrl + id,
    method: 'GET',
  });
}
export function getDictGroupTreeData() {
  return request({
    url: Api.getDictGroupTreeDataUrl,
    method: 'GET',
  });
}

export function changeEnable(params) {
  return request({
    url: Api.changeEnableUrl,
    method: 'POST',
    data: params,
  });
}
export function deleteData(id) {
  return request({
    url: Api.deleteUrl + id,
    method: 'DELETE',
  });
}
export function view(id) {
  return request({
    url: Api.viewUrl + id,
    method: 'GET',
  });
}
export function getListData(params) {
  return request({
    url: Api.listUrl,
    method: 'POST',
    data: params,
  });
}

export function save(params) {
  return request({
    url: Api.saveUrl,
    method: 'PUT',
    data: params,
  });
}

