import { store } from '@/store/index.ts';
import {computed} from "vue";
import {RouteRecordRaw} from "vue-router";

/**
 * 菜单收起|折叠
 */
export function changeMenuCollapse():void {
  return store.dispatch('app/changeCollapse')
}

/**
 * 过滤出显示的路由
 */
export function filterShowMenus(arr: Array<RouteRecordRaw>): Array<RouteRecordRaw> {
  return arr
    .filter(item => !item.meta || !item.meta.isHide)
    .map(item => {
      item = Object.assign({}, item);
      if (item.children) {
        item.children = filterShowMenus(item.children);
      }
      return item;
    });
}

export function useAppState() {
  return {
      computeThemeConfig: computed(() => {
        return store.state.themeConfig.themeConfig;
      }),
      computeApp: computed(() => {
        return store.state.app;
      }),
  }
}
