import request from '@/utils/request';

enum Api {
  listUrl = '/sys/CodeRule/list',
  saveUrl = '/sys/CodeRule/save',
  deleteUrl = '/sys/CodeRule/delete/',
  viewUrl = '/sys/CodeRule/view/',
  changeEnableUrl = '/sys/CodeRule/changeEnable',
}
export function changeEnable(params) {
  return request({
    url: Api.changeEnableUrl,
    method: 'POST',
    data: params,
  });
}
export function deleteData(id) {
  return request({
    url: Api.deleteUrl + id,
    method: 'DELETE',
  });
}
export function view(id) {
  return request({
    url: Api.viewUrl + id,
    method: 'GET',
  });
}
export function getListData(params) {
  return request({
    url: Api.listUrl,
    method: 'POST',
    data: params,
  });
}

export function save(params) {
  return request({
    url: Api.saveUrl,
    method: 'PUT',
    data: params,
  });
}

