# Hibernate条件查询工具类使用

Hibernate 复杂查询需要依赖工具类—— **HqlWhereHelper** ，通过调用工具类 **buildConditions()** 方法，生成带顺序的条件列表**LinkedList<Condition>**  ，最终按顺序生成HQL语句。

## 简单使用示例

**HqlWhereHelper** 调用示例：

```java
LinkedList<Condition> conditions = HqlWhereHelper.getInstance().and("key","value").buildConditions();
```

**HqlWhereHelper** 条件之间分为AND和OR，sql参数过滤方式 **FilterType** 又分为EQUAL、NOTEQUAL、LIKE、IN、NOTIN

| **FilterType** | 对应sql符号 |
| -------------- | ----------- |
| EQUAL          | =           |
| NOTEQUAL       | !=          |
| LIKE           | like        |
| IN             | in          |
| NOTIN          | not in      |
| ISNULL         | is null     |
| ISNOTNULL      | is not null |
| GT             | >           |
| LT             | <           |
| GE             | >=          |
| LE             | <=          |



**HqlWhereHelper ** 条件组合的方法列表如下，所有的方法都可以重复调用并随意组合，第一个方法也可以随意调用，不会多生成一个and或者or：

```java
 /**
     * 使用and拼接map中的参数，sql参数过滤方式为filterType
     *
     * @param paramMap   参数map
     * @param filterType sql参数过滤方式
     * @return
     */
    public HqlWhereHelper andParamMap(Map<String, Object> paramMap, FilterType filterType);

    /**
     * 使用or拼接map中的参数，sql参数过滤方式为filterType
     *
     * @param paramMap   参数map
     * @param filterType sql参数过滤方式
     * @return
     */
    public HqlWhereHelper orParamMap(Map<String, Object> paramMap, FilterType filterType);

    /**
     * 使用and拼接参数，默认过滤方式为FilterType.EQUAL
     *
     * @param key   参数key
     * @param value 参数value
     * @return
     */
    public HqlWhereHelper and(String key, Object value);

    /**
     * 使用or拼接参数，默认过滤方式为FilterType.EQUAL
     *
     * @param key   参数key
     * @param value 参数value
     * @return
     */
    public HqlWhereHelper or(String key, Object value);

    /**
     * 使用and拼接参数，过滤方式为FilterType.LIKE
     *
     * @param key   参数key
     * @param value 参数value
     * @return
     */
    public HqlWhereHelper andLike(String key, Object value);

    /**
     * 使用or拼接参数，过滤方式为FilterType.LIKE
     *
     * @param key   参数key
     * @param value 参数value
     * @return
     */
    public HqlWhereHelper orLike(String key, Object value);

    /**
     * 使用and拼接参数
     *
     * @param key        参数key
     * @param value      参数value
     * @param filterType 过滤方式
     * @return
     */
    public HqlWhereHelper and(String key, Object value, FilterType filterType);

    /**
     * 使用or拼接参数
     *
     * @param key        参数key
     * @param value      参数value
     * @param filterType 过滤方式
     * @return
     */
    public HqlWhereHelper or(String key, Object value, FilterType filterType);

 	/**
     * 使用and 拼接组合条件的前括号
     *
     * @return
     */
    public HqlWhereHelper addGroup();

    /**
     * 使用or 拼接组合条件的前括号
     *
     * @return
     */
    public HqlWhereHelper orGroup();

    /**
     * 后括号
     *
     * @return
     */
    public HqlWhereHelper endGroup();
```

组合条件示例：

```java
LinkedList<Condition> conditions = HqlWhereHelper.getInstance()
                .or("key1","value1")
                .or("key2","value2")
                .and("key3","value3")
                .andLike("key4","value4")
                .orLike("key5","value5")
                .buildConditions();
```

## 组合嵌套条件

在HQL中有部分条件需要组合和嵌套，**HqlWhereHelper** 支持使用 `addGroup()` 、`orGroup()`、`endGroup()`来实现组合和嵌套，`addGroup()`与`orGroup()`需要配合`endGroup()`来写。

addGroup 生成的代码是AND 加上左括号

```sql
AND (
```

orGroup生成的代码是 OR 加上左括号

```sql
OR (
```

而endGroup生成右括号

```sql
)
```

以下是示例：

```java
LinkedList<Condition> conditions = HqlWhereHelper.getInstance()
                .and("key1","value1")
    			.addGroup()
                .and("key2",10,FilterType.GE)
    			.and("key2",50,FilterType.LE)
    			.endGroup()
                .orLike("key3","value3")
                .buildConditions();
```

上面代码生成的条件如下：

```sql
WHERE key1=value1 AND (key2>=10 AND key2<=50) OR key3 like 'value3'
```





