# LDP代码生成IDEA插件安装和使用说明

LDP Generate是基于MyBatis-Plus 的官方代码生成器开发的一个IDEA插件，可以通过在界面上做表选择，以及一些简单的配置可以快速生成 Entity、Mapper、Mapper XML、Service、Controller 等各个模块的代码。

## 一、IDEA插件安装

首先，下载插件安装包：[ldp-mybatis-plugin](http://devdown.shxrtech.com/ldp-mybatis-plugin-1.0-SNAPSHOT.zip)

打开IDEA，File菜单，点击Settings

![](../imgs/generate/plugin-install-001.png)

选择Plugin，再右上侧选择从硬盘安装，选择刚才下载的安装包，然后重启IDEA即可

![安装界面](../imgs/generate/plugin-install-002.png)

## 二、数据库配置

重启好IDEA后，在最上面的菜单中会多出一个**LDP Generate**的菜单，点看后会有两个子菜单`DB Config`和`Code Generate`分别是数据库连接配置。

点击`DB Config `在弹窗中输入数据库连接，选择驱动，目前支持mysql和oracle，输入用户名及密码，配置好后，点击左下角**TESTCONNECTION**可以查看是否配置正确，如果配置正确，配置会被保存下来。

![数据库配置](../imgs/generate/dbconfig.png)



## 三、代码生成配置

点击`Code Generate` 菜单，会根据数据库连接配置拉取表信息，选择需要生成的表，并点击下一步

![表选择](../imgs/generate/table-choice.png)



详细配置界面一共分为3部分配置，基础配置、业务模块、业务模型

![](../imgs/generate/generate-setting.png)

**基础配置**是属于全局配置一共4个配置项，相关配置对应如下：

| 配置项        | 说明                                        | 默认值    |
| ------------- | ------------------------------------------- | --------- |
| 开发者        | 类名注释中的author                          | generator |
| swagger注解   | 是否启用swagger，影响范围entity、controller | 是        |
| 是否覆盖      | 是否覆盖相同路径同名文件                    | 否        |
| version乐观锁 | 是否将表里的version字段加上@Version注解     | 否        |



**业务模块**是对整个业务模块的配置，一个业务模块会有多个业务模型，相关配置项如下：

| 配置项           | 说明                                                         | 默认值                 |
| ---------------- | ------------------------------------------------------------ | ---------------------- |
| 模块编码         | 影响请求路径，代码生成路径、包名。**修改后，失焦事件会修改包名** | generate               |
| 包名             | 基础包名+模块编码，**修改后,失焦事件会自动填充模块编码**     | com.sinra.ldp.generate |
| 代码模块路径     | 代码生成的路径位于项目工程中模块路径，例如demo-startup       | 项目根目录             |
| eneity层目录     | 修改后，entity代码生成到对应的工程模块                       | 项目根目录             |
| mapper层目录     | 修改后，mapper、xml代码生成到对应的工程模块                  | 项目根目录             |
| service层目录    | 修改后，service、impl代码生成到对应的工程模块                | 项目根目录             |
| congroller层目录 | 修改后，controller代码生成到对应的工程模块                   | 项目根目录             |



**业务模型**会根据在选择表界面选择的表，动态生成多个tab页，每个tab页代表一张表

| 配置项   | 说明                            | 默认值                   |
| -------- | ------------------------------- | ------------------------ |
| 模型编码 | 用作请求路径                    | 表名去掉下划线，并转小写 |
| 数据表名 | 数据表名                        | 数据表名                 |
| 备注     | 用作swagger接口注解，一部分注释 | 数据表设计时的注释       |



点击生成后，根据配置生成代码，并自动打开文件管理器，显示出代码生成的位置。如果需要查看日志文件，可以在项目目录/.idea目录下，命名规则为**ldp-generate-时间.log**



