# LDP应用页面权限项配置说明

在应用开发中，常常会面临着对界面权限进行控制，例如：编辑界面、查看界面等等相关的界面权限控制；也会涉及到界面元素相关控制，例如：删除按钮、下载按钮、点击出现弹窗的按钮等等。在LDP中，通过对页面权限项配置就可以实现对界面、界面元素控制。

## 一、添加权限项

目前LDP内置的权限项一共有7个，分别是：

| 权限名称 | 权限编码   | 是否默认挂载 |
| -------- | ---------- | ------------ |
| 视图权限 | VIEW       | 是           |
| 新增权限 | ADD_BTN    | 是           |
| 删除权限 | DEL_BTN    | 是           |
| 详情权限 | DETAIL_BTN | 否           |
| 编辑权限 | EDIT_BTN   | 否           |
| 审批权限 | AUIT_BTN   | 否           |
| 弹窗权限 | DIALOG_BTN | 否           |

如需扩展权限项，目前需要通过插入语句，新增数据到`ldp_mcs_element_info`

```sql
INSERT INTO `ldp_mcs_element_info`(`id`, `ele_name`, `ele_code`, `ele_type`, `ele_loadtype`, `create_id`, `create_time`, `scope_id`, `update_id`, `update_time`) VALUES ('3xfbe26074fc8yt12', '其它权限', 'DEFAULT_BTN', 'DEFAULT', 0, 'admin', '2020-06-24 16:02:13', 'pageview', 'admin', '2020-06-24 16:02:16');
```

## 二、挂载权限项

登录LDP-MCS，打开菜单**系统维护**=>**应用菜单维护**， 鼠标悬浮在应用的菜单上，点击权限项：

![权限项-菜单维护](../progress/82权限项-菜单维护.png)

在弹出窗口里面将需要用到的权限项挂载过去，点击确定即可：

![权限项挂载](../progress/83权限项挂载.png)

## 三、角色授权

打开菜单**权限管理**=>**应用菜单权限** ，在对应角色后点击 **权限配置** ，之后就可以对角色进行权限项配置，勾选上即为授权，不勾选就取消授权，最后点击保存即可。

![](../progress/84权限配置.png)



## 四、前端代码修改

修改前端脚手架中的业务代码，给相关的元素配置权限详情参考文档：[LDP前端权限控制说明](http://gitlab.dev.shxrtech.com/doc/ldp-docs/blob/master/开发文档/LDP前端权限控制使用说明.md)