# BPM安装部署文档

流程管理系统需要依赖于LDP框架**1.1.22**以上，如果版本过低，请先升级版本。

## 一、修改NACOS配置文件

如果LDP框架版本是由低版本升级，也可需要先导入，再修改，下载地址：[bpm配置文件](http://devdown.shxrtech.com/nacos-config-bpm-2021-02-08.zip)

#### 导入BPM配置文件（版本1.1.22以上可忽略）

上传文件时选择下载的zip包即可。

![导入](../progress/85导入配置.png)

修改gateway配置文件`gateway-service-dev.yml`、`gateway-service-prod.yml`，增加bpm应用配置

```yml
	
      - id: bpm-app
        realmcode: app
        clientid: mcpsos0mqwqzd60t
```



#### 修改BPM配置文件

如果是从**1.1.22**开始安装的，则只需要修改nacos上的配置文件，`bpm-service-dev.yml`、`bpm-service-prod.yml`,

##### 修改数据库连接

![修改数据库连接](../progress/86修改数据库连接.png)



##### 修改redis连接

![修改redis连接](../progress/87修改redis连接.png)



## 二、解压tar.gz包并拷贝文件

首先需要解压bpm压缩包

```shell
# 当前目录是ldp-manage
tar -zxvf ldp-bpm-1.0.0.tar.gz
```

解压后的目录结构

```shell
bpm
├── bpm-startup-1.0.0.jar
└── ui
    └── bpm
        ├── favicon.ico
        ├── fonts
        ├── img
        ├── index.html
        └── static
            ├── css
            ├── img
            └── js
```

拷贝jar包到fatjar目录

```shell
# 拷贝jar包
cp bpm/bpm-startup-1.0.0.jar fatjar/
```

拷贝静态文件到nginx/html目录

```shell
# 拷贝静态文件到html目录
cp -r bpm/ui/bpm /usr/local/nginx/html/
```

修改nginx配置文件，添加以下内容

```conf
 location /bpm {
 	try_files $uri $uri/ /bpm/index.html;
 }
```

重启nginx

```shell
#关闭nginx
./nginx -s stop
```

```shell
#启动nginx
./nginx
```



## 三、启动bpm服务

```shell
# 启动
cd tool/
./bpm-boot.sh start
```



## 四、安装字体文件

绘制流程图时，如果有中文，需要配置字体文件，并在安装服务器上安装字体文件，否则绘制的流程图会出现乱码 ，默认已经配置为宋体，bootstrap-dev.yml 或 bootstrap-prod.yml

```
ldp:
  flowable:
    font-name: 宋体
```

在服务器上安装相应字体，这里用宋体举例，参考： https://www.cnblogs.com/cuishuai/p/8441132.html

 **linux 字体安装：**

```shell
# 安装字体配置
yum install -y fontconfig mkfontscale

#从windows系统中复制C:\Windows\Fonts\simsun.ttc 宋体字体文件到目录/usr/share/fonts/

 # 创建字体缓存
cd /usr/share/fonts/ & mkfontscale & mkfontdir & fc-cache

#查看中文字体
fc-list :lang=zh
```

**重启服务**

```shell
./bpm-boot.sh start
```



## 五、常见问题QA

如果遇到启动时flyway报以下错误：

```log
2021-04-13 17:01:03,836 [ERROR] [main] org.flywaydb.core.internal.command.DbMigrate [Slf4jLog.java : 57] Migration of schema `sinra_bpm_db` to version 1.0.1 - create bpm table failed! Please restore backups and roll back database and code!
2021-04-13 17:01:05,023 [ERROR] [main] org.springframework.boot.SpringApplication [SpringApplication.java : 826] Application run failed
org.springframework.beans.factory.BeanCreationException: Error creating bean with name 'initFlywayLoader' defined in class path resource [com/sinra/ldp/bpm/config/SyncUserInfoToRedisConfig.class]: Invocation of init method failed; nested exception is org.flywaydb.core.internal.command.DbMigrate$FlywayMigrateException: 
Migration V1.0.1__create_bpm_table.sql failed
---------------------------------------------
SQL State  : 42S02
Error Code : 1146
Message    : Table 'sinra_bpm_db.act_ge_bytearray' doesn't exist
Location   : db/mysql/V1.0.1__create_bpm_table.sql (/usr/local/ldp-manage/tool/file:/usr/local/ldp-manage/fatjar/bpm-startup-1.0.7.jar!/BOOT-INF/classes!/db/mysql/V1.0.1__create_bpm_table.sql)
Line       : 105
Statement  : INSERT INTO `act_ge_bytearray`(`ID_`, `REV_`, `NAME_`, `DEPLOYMENT_ID_`, `BYTES_`, `GENERATED_`)
VALUES ('0876769a-7d57-11eb-8fd3-02429dba8ba5', 1, 'source', NULL,
        0x3C3F786D6C2076657273696F6E3D22312E302220656E636F64696E673D225554462D38223F3E0A3C62706D6E323A646566696E6974696F6E732078
```

检查mysql是否区分大小写，在mysql执行：

```sql
show Variables like '%table_names'
```

确认`lower_case_table_names`值是否为1，如果不等于1，则表示开启了大小写区分，按照以下步骤处理：

1. 关闭大小写区分;
2. 删掉之前创建的表;
3. 重新启动BPM;