# 报表系统打印模板使用

## 一、制作打印模板

操作说明请查看[报表系统集成使用文档 ](./报表系统集成使用文档.md)中的报表管理。



## 二、功能菜单配置打印模板

首先进入到应用菜单维护页面

![image-20210518162358125](./image/85进入到应用菜单维护页面.png)



设置功能菜单基本信息

![image-20210518163317226](./image/86设置功能菜单信息.png)

点击选择报表模板

![image-20210518163415024](./image/87选择报表模板.png)

点击保存

![image-20210518163507027](./image/88功能菜单模板保存.png)



授权功能权限

![image-20210518163818277](./image/89授权打印模板功能菜单权限.png)



## 三、前端使用打印模板

当前参数页面代码(仅使用打印模板功能)。

前端脚手架需要使用最新报表，非最新版本请替换脚手架中`src/router/loadRouter.js`代码，另外需引入`src/utils/report.js`

**`report.js`** 中提供两个打印报表相关函数。

`getReportUrl` 用于页面功能id关联的报表信息。

`openReportPreview`  用于通过功能id获取到关联报表信息，并直接打开报表预览页面。

使用请查看下面代码示例

```vue
<template>
  <div>
    <el-button @click="getReportInfo">
        获取报表信息
    </el-button>
    <el-button @click="preview">
        预览报表
    </el-button>
  </div>
</template>
<script>
import { openReportPreview, getReportUrl } from '@/utils/report'
export default {
  data() {
    return {}
  },
  methods: {
     getReportInfo() {
      /**
       * 通过接口获取当前功能id关联报表的信息。
       *  第一个参数为当前页面功能id, 动态挂载的页面会经过路由设置，自动会将funcId挂到meta对象上
       */
      getReportUrl(this.$route.meta.funcId).then(res => {
        console.log(res)
      })
    },
    preview() {
      /**  
       *  打开预览报表页面
       *  第一个参数为当前页面功能id, 动态挂载的页面会经过路由设置，自动会将funcId挂到meta对象上
       *  第二个参数为替换对象， 如果报表模板设置了url参数那么getReportUrl 返回的url的地址需要替换参数，格式为{变量}
       *  如"/ureport-service/open/urv?reportid=36681d5743d33ab479e23b23c16f5ad1&realmcode={realmcode}&userAccount={userAccount}"
       *  realmcode为必须参数。 默认会使用当前脚手架中环境配置的`process.env.VUE_APP_REALMCODE`值替换
       *  如果不替换直接打开地址，可能会url地址解析失败，或者造成参数错误等问题。
       */
      openReportPreview(this.$route.meta.funcId, {
        userAccount: 'admin'
      })
    }
  }
}
</script>

```



调用预览接口，进行打开报表预览页面

![image-20210610155659161](./image/90预览打印报表.png)