# MCS快速开发-发布功能使用文档

发布功能是属于MCS快速开发中的一个功能。为了避免每次生成代码后需要手动的打包上传，结合Gitlab+Jenkins ，仅需要简单的配置就能快速的将生成的代码部署到线上（开发环境/测试环境）等。

发布功能主要由2步组成

1、将生成的代码推送到指定的代码仓库、指定的代码分支

2、Jenkins 自动检测代码变更并进行打包部署。



## 一、发布配置管理

由于发布功能需要推送代码，所以在发布前，我们需要知道代码推送到哪个仓库以及哪个分支，于是这里添加上发布配置管理。

打开MCS管理平台，打开菜单  **快速开发** =》**发布配置管理**

![发布配置管理](../progress/72发布配置管理.png)

### 1.1 新增发布配置

点击列表上的 **新增** 按钮

![新增发布配置](../progress/73新增发布配置.png)



表单的字段的含义以及注意事项见下表：

| 字段名         | 内容                                                         | 备注                                     |
| -------------- | ------------------------------------------------------------ | ---------------------------------------- |
| 配置别名       | 可以通过别名判断发布的环境等相关信息                         |                                          |
| 应用           | 将功能发布到哪个应用                                         | 这里的应用来源于应用认证管理中的应用列表 |
| 服务名         | 生成前端代码时，请求中接口服务名( 例如: example-service/user/get/page) | 前端生成的代码元数据和代码也依赖服务名   |
| git服务类型    | 根据git仓库不一样，api也略微不同，这里暂时只支持gitlab       |                                          |
| 后端git地址    | 后端工程git仓库地址                                          |                                          |
| 后端分支名     | 后端工程分支名                                               |                                          |
| 前端git地址    | 前端工程git仓库地址                                          |                                          |
| 前端分支名     | 前端工程分支名                                               |                                          |
| git账号        | git仓库的登录账号                                            | 账号中不能出现`@`符号                    |
| git密码        | git仓库的登录密码                                            |                                          |
| 是否为默认配置 | 每个应用只会有一个默认配置，如果添加一个新的默认配置，以前的默认配置会被换掉 |                                          |

接下来是新建业务模型，如果不太清楚如何新建数据模型，请参考[LDP代码生成功能操作说明v1.2.docx](LDP代码生成功能操作说明v1.2.docx)

## 二、生成前端代码

打开菜单 **快速开发** => **视图设计** ，点击`新增`按钮。

![新增视图设计](../progress/74新增视图设计.png)

在选择模板的弹窗中选择对应的模板、布局方式、所属应用(`这里的应用决定了，代码发布的时候使用什么配置`)、业务模型、数据模型。

![选择模板](../progress/75模板选择.png)

点击确定后，在左侧的树就生成了对应的前端代码

![前端视图树](../progress/76前端视图树.png)

## 三、发布代码

点击右上角的发布按钮，在弹窗中选择所属应用以及业务模型。（需要注意，发布前请检查是否生成前端代码）

![发布模型](../progress/77发布模型.png)

这里选择默认应用系统，那么发布配置就读取的是对应的默认配置，git仓库地址、分支等相关信息。弹窗中`同步后端代码` 选项是只是否同时发布后端代码，如果值为否的话，就只会发布前端代码，如果值为是的话，就会将此业务模型的前后端代码一起发布。

