# LDP前端脚手架工程联调配置说明

## 脚手架默认配置说明

> 在开发环境中脚手架默认代理转发`/dev-api `头的请求地址。

```javascript
// .env.development
// 默认代理转发的请求前缀
VUE_APP_BASE_API = '/dev-api'
// 默认代理服务器地址
VUE_APP_PROXY_SERVER = 'http://47.103.46.222:9080'

// 网关登录相关配置
VUE_APP_ID = 'app-ui'
VUE_APP_REALMCODE = 'app'
// 授权登录跳转的路由地址， 开发环境下默认是VUE_APP_PROXY_SERVER + VUE_APP_AUTH_SERVICE
VUE_APP_AUTH_SERVICE = 'ldp-service/login'
```

```javascript
 // vue.config.js  vue代理转发配置
proxy: {
    // 请求代理的前缀路由地址
    [process.env.VUE_APP_BASE_API]: {
		// 目标服务器地址
        target: process.env.VUE_APP_PROXY_SERVER,
            changeOrigin: true,
            pathRewrite: {
                // 重写路由地址将process.env.VUE_APP_BASE_API 开头地址重写成''
                // 假设请求地址为/dev-api/mcs-service/user/userinfo
                // 也就是/dev-api开头地址的会自动转换为 'http://47.103.46.222:9080/mcs-service/user/userinfo' 进行代理请求
                 ['^' + process.env.VUE_APP_BASE_API]: ''
        }
    }
}
```

## 联调说明

> 通常情况下平台都需要登录才能进行接口访问， 也就是需要从授权登录页面获取到token，然后再进行操作， 那么就需要先配置 授权的相关信息。
> 如果只是服务器地址变化，则修改 `VUE_APP_PROXY_SERVER` 即可。
>
> 后端本地联调则需要进行路由转发配置， 假设后端访问的接口是`example-service/user/userinfo`

```javascript
// vue.config.js
// 如果用框架内部的`request` 或`this.$http` 请求的话默认会拼接
const proxyPath = process.env.VUE_APP_BASE_API + '/example-service'
// 如果是其他方式比如说一个资源请求，或者第三方库自带内部的请求
const otherPath =  '/example-service'
// 代理设置对象
proxy: {
    // 第一种默认请求方式的代理转发
    proxyPath: {
        target: `http://192.168.0.106:8800`,
        changeOrigin: true,
        pathRewrite: {
        	'^' + proxyPath: ''
        }
    },
    // 第二种用其他请求方式的代理转发
    otherPath: {
        target: `http://192.168.0.106:8800`,
        changeOrigin: true,
        pathRewrite: {
        	'^' + otherPath: ''
        }
    },
    //  默认的配置
     [process.env.VUE_APP_BASE_API]: {
        	target: process.env.VUE_APP_PROXY_SERVER,
            changeOrigin: true,
            pathRewrite: {
                 ['^' + process.env.VUE_APP_BASE_API]: ''
            }
     }
}
```

