# LDP第三方对象存储服务使用说明

相关配置和使用案例，已经更新到脚手架工程 [**ldp-app-example**](http://gitlab.dev.shxrtech.com/ldp/ldp-app-example) ，具体代码在example-biz模块中。

## 一、云对象存储介绍

云对象存储是一种基于互联网的简单对象存储服务，并提供简单易用的RESTFul接口，使用户在任何时间，任何地点都能通过互联网访问对象存储中的数据。LDP支持这几种对象存储，阿里云、minio、七牛云、腾讯云，并且根据配置文件来指定使用其中的一种方式。

## 二、使用方式

### 2.1 添加Maven依赖

这里用脚手架工程举例， 在example-biz模块 pom.xml中添加common-storage依赖

```xml
<dependency>
    <groupId>com.sinra.ldp</groupId>
    <artifactId>common-storage</artifactId>
    <version>1.0-SNAPSHOT</version>
</dependency>
```

### 2.2 添加对象存储配置

在配置文件中添加云储存配置，active-server指定激活哪一种对象存储的配置，下图中激活的是qiniu（七牛云）。这里只是示例，使用时只需要填写使用的那份配置就行。

![oss-profile.png](../imgs/OSS-profile.png)

每一种配置都有些许差异，请仔细填写。

### 2.3 服务调用

`StorageService`有三个上传接口，分别是：

```java
 	/**
     * 上传文件到云存储, 返回下载HTTP地址
     * @param data 字节数据
     * @param fileName 文件名
     * @return HTTP地址
     * @throws Exception
     */
	String upload(byte[] data, String fileName) throws Exception;

	/**
     * 上传文件到云存储, 返回下载HTTP地址
     * @param inputStream 字节流
     * @param fileName 文件名
     * @return HTTP地址
     * @throws Exception
     */
	String upload(InputStream inputStream, String fileName) throws Exception;

	/**
     * 上传文件到云存储, 返回下载HTTP地址
     * @param file 文件
     * @param fileName 文件名
     * @return HTTP地址
     * @throws Exception
     */
	String upload(File file, String fileName) throws Exception;
```

样例工程中使用的是byte[]，以下是样例代码：

```java
//注入StorageService
@Autowired
StorageService storageService;

@Override
public String uploadToCloudStorage(MultipartFile file) {
    String uploadPath = null;
    try {
        //调用上传方法，返回的是下载地址
        uploadPath = storageService.upload(file.getBytes(), file.getOriginalFilename());
    } catch (Exception e) {
        e.printStackTrace();
        //写入日志并抛出异常
        log.error(e.getMessage(), e);
        throw new BizException(500, e.getMessage());
    }
    return uploadPath;
}
```

