# LDP流程系统集成前端功能表单说明
LDP流程系统是LDP框架内负责管理，设计流程模型并提供流程服务的专门业务系统。    
业务系统在集成流程系统过程中，需要给流程系统提供审批过程所需的表单页面（数据和视图页面），流程系统需要在审批过程中调用业务系统的单据页面供审批用户查看，由于是跨系统的集成方式，需要被集成方在其需要审批的页面中遵循流程系统前端集成业务系统前端应用的相应的规范和模式，以达到流程系统可跨系统集成查看审批表单页面的业务需求。   
框架内前端页面需要集成流程系统（被流程系统前端集成）的相关集成配置说明如下文。



## 前端脚手架应用中集成说明（外挂VUE方式）

外置VUE集成表单支持三种表单状态

- BPM_SUBMIT： 提交状态， 用来标志当前页面可以支持新增表单数据
- BPM_EDIT： 编辑状态, 用来标志当前页面可以支持编辑表单并保存数据
- BPM_DETAIL: 编辑状态， 用来标志当前页面可以支持详情表单，及是查看表单数据

提交表单集成代码示例

```vue
<script>
import BpmCtrl from '@/mixins/BpmCtrl'
export default {
    mixins: [BpmCtrl],
    data() {
        return {
            bpm: {
                // 当前表单支持的流程表单状态
                matchFormStatus: ['BPM_SUBMIT']
            }
        }
    },
    methods: {
        // 定义流程执行方法
        bpmSubmit(callback) {
            this.submit(callback)
        },
        // 业务数据提交方法
        submit(callback) {
            let data = {}
            this.$http.post(url, data)
            .then(res => {
                if (res.success) {
                    // 成功需要提交数据返回的id
                    callback(res.data)
                    return
                } else {
                    // 失败返回一个对象， 对象中如果存在error则表示接口出错
                    callback({
                        error: res.message
                    })
                }
                // 
            }).catch(error => {
                callback({ error })
            })
        }
    }
}
<script>
```



编辑表单集成代码示例

```vue
<script>
import BpmCtrl from '@/mixins/BpmCtrl'
export default {
    mixins: [BpmCtrl],
    data() {
        return {
            id: '',
            bpm: {
                // 当前表单支持的流程表单状态
                matchFormStatus: ['BPM_EDIT']
            }
        }
    },
    created() {
        // bpm系统默认会通过url传递id参数。
        // this.id = this.$route.query.id
        // ...
    },
    methods: {
        /**
        * 定义流程执行方法 可以直接使用返回Promise， 则不需要业务代码中做其他loading和返回处理
        * Promise 成功接收数据格式如下
        * {
        *   success: true, // 返回表示成功
        *   data: 'id' // 返回id的数据
        * }
        */
        bpmSubmit(callback) {
            const data = this.getSubmitData()
            return this.$http.post(url, data)
        },
        // 获取提交数据
        getSubmitData() {
            const data = {}
            // ...处理数据
            return data
        }
    }
}
<script>
```



详情表单集成代码示例

```vue
<script>
import BpmCtrl from '@/mixins/BpmCtrl'
export default {
    mixins: [BpmCtrl],
    data() {
        return {
            id: '',
            bpm: {
                // 当前表单支持的流程表单状态
                matchFormStatus: ['BPM_DETAIL']
            }
        }
    },
    created() {
        // 需要接收id参数来获取表单数据
        // this.id = this.$route.query.id
    },
    methods: {
        // 详情模式只是查看数据，不需要定义方法
    }
}
<script>
```



结合表单代码示例

```vue
<script>
import BpmCtrl from '@/mixins/BpmCtrl'
export default {
    mixins: [BpmCtrl],
    data() {
        return {
            bpm: {
                // 当前表单支持的流程表单状态
                BPM_SUBMIT: {
                    submitFun: 'submitAdd',
                },
                BPM_EDIT: {
                    submitFun: 'submitEdit'
                },
                BPM_DETAIL: {
                    
                },
                matchFormStatus: ['BPM_SUBMIT', 'BPM_EDIT', 'BPM_DETAIL']
            }
        }
    },
    methods: {
        getSubmitData() {
            const data = {}
            // ... 获取数据
            return data
        },
        // 定义提交表单方法
        submitAdd() {
            const data = this.getSubmitData()
            return this.$http.post(url, data)
        },
        // 定义编辑表单方法
        submitEidt() {
            const data = this.getSubmitData()
            return this.$http.post(url, data)
        },
    }
}
<script>
```



表单配置模式示例

集成状态说明

- 支持 `BPM_SUBMIT`  `BPM_DETAIL`  `BPM_EDIT`  三种模式
- `includeFormStatus` 表示当前页面支持那种模式表单， 如果不支持的话则默认全部禁用， 按钮隐藏。
- 状态说明
  1. 提交状态默认隐藏按钮 (隐藏规则根据类名'el-button')
  2. 编辑状态默认隐藏按钮 (隐藏规则根据类名'el-button')
  3. 详情状态默认禁用当前页面(**当前页面不能点击**)  隐藏按钮 设置部分`el-input el-select `等控件禁用状态

```vue
<template>
 	<el-form>
     	<!-- ... -->
        <span calss="btn-hidden" @click="openDlg">打开对话框<span>
        <el-button calss="btn-show" @click="lookView">查看视图</el-button>
    </el-form>
</template>
<script>
/**
* bpm 状态对象中各种状态内的属性说明
* hidden： 需要隐藏的类名
* disabled： 需要禁用的类名
* excludeClassName: 默认隐藏或者禁用中排除掉元素的类名
**/
import BpmCtrl from '@/mixins/BpmCtrl'
export default {
    mixins: [BpmCtrl],
    data() {
        return {
            bpm: {
                // 当前表单支持的流程表单状态
                BPM_SUBMIT: {
                    // 在提交模式下隐藏指定
                    hidden: 'btn-hidden',
                    // 在提交模式下默认隐藏按钮和禁用的控件中排除指定类名的元素
                    excludeClassName: 'btn-show',
                    // 自定义提交的方法。 当bpm状态为提交时候则自动触发此方法。
                    submitFun: 'submitAdd',
                },
            }
        }
    },
    created() {
    },
    methods: {
        // 打开一个对话框
        openDlg() {
             
        },
        // 查看某个数据
        lookView() {
 
        },
        getSubmitData() {
            const data = {}
            // ... 获取数据
            return data
        },
        // 定义提交表单方法
        submitAdd() {
            const data = this.getSubmitData()
            return this.$http.post(url, data)
        }
    }
}
<script>
```

自定义集成方案

> 当使用自定义模式时候, 将不会默认禁用和隐藏元素，
>
> 需要根据`formStatus` 状态来自动处理元素

```vue
<script>
    import BpmCtrl from '@/mixins/BpmCtrl' 
    export defult() {
        mixins: [BpmCtrl],
		data() {
            return {
                bpm: {
                    mode: 'custom'
                }
            }
        },
        methods: {
            /**
            * 引入BpmCtrl后会自动设置当前表单状态formStatus
            * 通过this.formStatus 来判断状态来处理页面显示逻辑
            **/
            init() {
                // ... this.formStatus
                if (this.formStatus === 'BPM_SUBMIT') {
                    // ...提交表单的处理
                } else if (this.formStatus === 'BPM_EDIT') {
                    // ... 编辑表单的处理
                } else if (this.formStatus === 'BPM_DETAIL') {
                    // ... 详情表单的处理
                }
            },
            bpmSubmit() {
                // ... 实现提交方法，进行接口数据操作
            }
        }
    }
</script>

```

## bpm流程系统集成配置说明

### 创建应用

进入应用管理页面，创建应用

![1612505975821](./images/01进入应用管理页面.png)

 点击新增

>前端应用名:  配置别名
>
>前端应用路径: 集成应用的路径地址， 例如显示应用地址访问为`http:xxx.com/demo` 那么路径地址就需要配置成demo,

![1612506169033](./images/02创建应用.png)

### 新建表单

进入到表单管理页面

![1612506766789](./images/03进入表单管理页面.png)



新建表单

![1612506968167](./images/04新增表单.png)

![1612507030908](./images/05新增表单(提交表单).png)

![1612507062998](./images/06新增表单(编辑详情表单).png)

![1614650751501](./images/07新增表单(详情表单).png)

表单新增完成

![1612507116968](./images/07新增表单完成.png)

### 绑定表单

进入到流程定义页面

![1612507242398](./images/08进入流程定义页面.png)

 在需要设置的流程定义上绑定表单

![1612507288751](./images/09绑定表单.png)

选择对应的表单确认绑定表单

![1612507397313](./images/10绑定表单(确认选择).png)


