# Knife4j&Swagger使用文档

knife4j是为Java MVC框架集成Swagger生成Api文档的增强解决方案,前身是swagger-bootstrap-ui,取名kni4j是希望它能像一把匕首一样小巧,轻量,并且功能强悍。

- 
  文档说明：根据Swagger的规范说明，网页方式详细列出接口文档的说明，包括接口地址、类型、请求示例、请求参数、响应示例、响应参数、响应码等信息。 

- 
  在线调试：提供在线接口联调的强大功能，自动解析当前接口参数,同时包含表单验证，调用参数可返回接口响应内容、headers、Curl请求命令实例、响应时间、响应状态码等信息，帮助开发者在线调试。



官网参考：https://doc.xiaominfo.com/knife4j/documentation/



项目启动后，接口文档访问地址：http://localhost:8800/doc.html

![Knife4j样例](../imgs/knife4j/knife4j-example.png)



## Swagger2注解使用

### 实体类注解

**@ApiModel** 用于注解实体类

**@ApiModelProperty** 用于注解实体类字段

样例：

![实体类注解](../imgs/knife4j/swagger2-entity.png)

### Controller层注解

**@Api** 用于注解Contoller

**@ApiOperation** 用于注解Contoller接口

**@ApiImplicitParams** 用于注解非对象参数集

**@ApiImplicitParam** 用于描述非对象参数

样例：

![Controller注解](../imgs/knife4j/swagger2-controller.png)

常用注解介绍：

| 作用范围           | API                | API常用参数                                                  | 作用位置                     |
| ------------------ | ------------------ | ------------------------------------------------------------ | ---------------------------- |
| 协议集描述         | @Api               | @Api(tags  = {"tag1","tag2","..."})                          | controller类                 |
| 协议描述           | @ApiOperation      | @ApiOperation(value  = "功能描述",notes  = "备注")           | controller类的方法           |
| 描述返回对象的意义 | @ApiModel          | @ApiModel(value="类名",description="类描述")                 | 实体对象类                   |
| 对象属性           | @ApiModelProperty  | @ApiModelProperty(value  = "类属性描述",required  = *true*,example = "属性举例",notes = "备注") | 出入参数对象的字段           |
| 非对象参数集       | @ApiImplicitParams | @ApiImplicitParams({@ApiImplicitParam(),@ApiImplicitParam(),...}) | controller的方法             |
| 非对象参数描述     | @ApiImplicitParam  | @ApiImplicitParam(name  = "参数名",value  = "参数描述",required  = *true*,paramType = "接口传参类型",dataType = "参数数据类型") | @ApiImplicitParams的方法里用 |
| Response集         | @ApiResponses      | @ApiResponses({    @ApiResponse(),@ApiResponse(),..})        | controller的方法             |
| Response           | @ApiResponse       | @ApiResponse(code  = 10001, message = "返回信息")            | @ApiResponses里用            |
| 忽略注解           | @ApiIgnore         | @ApiIgnore                                                   | 类，方法，方法参数           |