## LDP 应用（后台）集成流程服务说明
LDP应用集成流程服务已集成到最新版应用脚手架样例工程，以下代码及样例说明都是基于最新版框架应用开发脚手架工程。


### 应用系统集成使用流程引擎用例

- ##### 流程-发起

```java
/**
 * 服务层代码样例
 */
@Service
public class LdpCityServiceImpl extends AbsLocalBaseDao implements LdpCityService {
 
     /**
     * 注入流程服务类
     */
    @Autowired
    ProcessEngineService processEngineService;

    /**
     * 提交到流程系统
     * @param ldpCity
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    @AutoService
    @Override
    public String submit(LdpCity ldpCity) {
       
       //提交单据数据到本地数据库
       String id= (String) this.addOne(ldpCity);
       String formKey="demo";
       try {
           // 调用流程引擎启动服务，catch并抛出异常
           String instanceId = processEngineService.start(formKey, id, new ProcessParam());
       }catch (Exception e){
           throw e;
       }
       return id;
    }

}
```

Controller层

```java
/**
 * Controller层代码样例
 */
@RestController
@RequestMapping("localdemo/city")
public class LdpCityRest {

    /**
     * 流程业务-提交，发起流程
     *
     * @param city
     * @return
     */
    @PostMapping("/submit")
    public RestResult submitCity(@RequestBody LdpCity city) {
        String ID=ldpCityService.submit(city);
        return new RestResult(ResultMsg.SUCCESS, ID);
    }

}
```



- ##### 流程-批准同意

```java
/**
 * Controller层代码样例
 */
@RestController
@RequestMapping("localdemo/city")
public class LdpCityRest {

    @Autowired
    ProcessEngineService processEngineService;

    /**
     * 流程业务-批准同意
     * @return
     */
    @GetMapping("/approve")
    public RestResult approve(@RequestParam String businessKey,@RequestParam String comment) {

        return new RestResult(ResultMsg.SUCCESS, processEngineService.agree(businessKey,comment));
    }

}
 
```
- ##### 流程-打回
```java
/**
 * Controller层代码样例
 */
@RestController
@RequestMapping("localdemo/city")
public class LdpCityRest {

    @Autowired
    ProcessEngineService processEngineService;

   /**
     * 流程业务-不同意，打回
     * @return
     */
    @GetMapping("/reject")
    public RestResult reject(@RequestParam String businessKey,@RequestParam String comment) {

        return new RestResult(ResultMsg.SUCCESS, processEngineService.reject(businessKey,comment));
    }

}
 
```
- ##### 流程-获取待办列表

```java
/**
 * Controller层代码样例
 */
@RestController
@RequestMapping("localdemo/city")
public class LdpCityRest {

    @Autowired
    ProcessEngineService processEngineService;

    /**
     * 流程业务-待办列表
     * @return
     */
    @GetMapping("/todo")
    public RestResult toDo() {

        return new RestResult(ResultMsg.SUCCESS, processEngineService.getTodoList());
    }

}
 
```


### 集成流程引擎核心服务类

#### BpmClientFeignService，feign服务方式调用流程引擎服务(bpm-service)接口类
```java

/**
 * 业务流程服务 bpm-service client 接口服务
 * @author xiaomage
 */
@FeignClient(value = "bpm-service",configuration = HeaderRequestInterceptorForToken.class)
public interface BpmClientFeignService {


    /**
     *  启动流程
     * @param formKey 表单KEY
     * @param businessKey 业务流程ID，一般为单据或表单ID
     * @param startParam 启动参数
     * @return 流程实例ID
     */
    @PostMapping("/process/open/start")
    RestResult<String> start(@RequestParam("formKey") String formKey, @RequestParam("businessKey") String businessKey, @RequestBody ProcessParam startParam);

    /**
     * 获取审批流程内容
     * @param businessKey 单据或表单ID
     * @return 审批意见列表
     */
    @GetMapping("/process/comment/list")
    RestResult<List<ProcessComment>> getProcessComments(@RequestParam("businessKey") String businessKey);


    /**
     * 流程审批流程图
     *
     * @param businessKey 单据或表单ID
     * @return 流程图byte数组
     */
    @GetMapping("/process/open/image")
    RestResult<byte[]> getProcessInstanceImage(@RequestParam("businessKey") String businessKey);

    /**
     * 获取待办列表
     * @param formKey
     * @return 待办列表
     */
    @GetMapping("/process/open/todo/list")
    RestResult<List<ProcessInfo>> getTodoList(@RequestParam("formKey") String formKey);

    /**
     * 获取待办列表
     * @return 待办列表
     */
    @GetMapping("/process/open/todo/list")
    RestResult<List<ProcessInfo>> getTodoList();

    /**
     * 终止流程
     * @param businessKey 表单ID
     * @param comment 审批意见
     * @return 
     */
    @PostMapping("/process/open/stop")
     RestResult stop(@RequestParam("businessKey") String businessKey, @RequestParam("comment") String comment);


    /**
     * 审批同意（到下一个审批节点）
     * @param businessKey 表单ID
     * @param comment 审批意见
     * @return
     */
    @PostMapping("/process/open/agree")
    RestResult agree(@RequestParam("businessKey") String businessKey, @RequestParam("comment") String comment);

    /**
     * 拒绝打回（到上一个审批节点）
     * @param businessKey 表单ID
     * @param comment 审批意见
     * @return
     */
    @PostMapping("/process/open/reject")
    RestResult reject(@RequestParam("businessKey") String businessKey, @RequestParam("comment") String comment);

    /**
     * 打回到起始节点
     * @param businessKey 表单ID
     * @param comment 审批意见
     * @return
     */
    @PostMapping("/process/open/back")
    RestResult back(@RequestParam("businessKey") String businessKey, @RequestParam("comment") String comment);

}


```

#### ProcessEngineService，应用集成流程引擎业务类

```java
/**
 * 流程引擎服务接口
 * @author xiaomage
 */
public interface ProcessEngineService {



    /**
     *  启动流程
     * @param formKey 表单KEY
     * @param businessKey 业务流程ID，一般为单据或表单ID
     * @param startParam 启动参数
     * @return 流程实例ID
     */
    String start( String formKey, String businessKey,ProcessParam startParam);

    /**
     * 获取审批流程内容
     * @param businessKey 单据或表单ID
     * @return
     */
    List<ProcessComment> getProcessComments( String businessKey);


    /**
     * 流程审批流程图
     *
     * @param businessKey 单据或表单ID
     * @return base64字符串
     */
    String  getProcessInstanceImage(String businessKey);

    /**
     * 获取待办列表
     * @param formKey
     * @return
     */
    List<ProcessInfo> getTodoList(String formKey);

    /**
     * 获取待办列表
     * @return
     */
    List<ProcessInfo> getTodoList();

    /**
     * 终止流程
     * @param businessKey 表单ID
     * @param comment 审批意见
     * @return
     */

     boolean stop(String businessKey,String comment);


    /**
     * 审批同意（到下一个审批节点）
     * @param businessKey 表单ID
     * @param comment 审批意见
     * @return
     */
    boolean agree(String businessKey, String comment);

    /**
     * 拒绝打回（到上一个审批节点）
     * @param businessKey 表单ID
     * @param comment 审批意见
     * @return
     */
    boolean reject(String businessKey,String comment);

    /**
     * 打回到起始节点
     * @param businessKey 表单ID
     * @param comment 审批意见
     * @return
     */
    boolean back(String businessKey,  String comment);
}

```

