# LDP前端权限控制使用说明
> 前端权限控制使用`vue`自定义指令操作`(v-ace)`。
> 一般是给按钮或者其他控件设置操作权限。

- 已在`main.js`中全局注册 直接使用就行。
  ```JavaScript
  import Vue from 'vue';
  import ACE from '@/directive/ace/index'; // 权限控制指令
  Vue.use(ACE);
  ```
  | 指令编码   | 说明 |
  | ---------- | ---- |
  | `DEL_BTN`  | 删除 |
  | `ADD_BTN`  | 新增 |
  | `EDIT_BTN` | 编辑 |

- 使用例子

  ```JavaScript
  // ... 使用v-ace:DEL_BTN 绑定删除权限
  <template>
    <el-button icon="el-icon-delete" v-ace:DEL_BTN type="danger" @click="handleDelete">
      删除
    </el-button>
  </template>
  // ... 也可以绑定动态变量
  <template>
    <el-button icon="el-icon-delete" v-ace="ace" type="danger" @click="handleDelete">
      删除
    </el-button>
  </template>
  
  <script>
      export default {
          data() {
              return {
                  // 也可以是,分割的多权限 比如 ADD_BTN,DEL_BTN
                  ace: 'DEL_BTN'
              }
          }
      }
  </script>
  ```