# LDP前端脚手架工程联调配置说明

版本支持： `ldp-appui-example`前端应用开发脚手架  `develop`  、`master`分支

## 脚手架默认配置说明

> 在开发环境中脚手架默认代理转发`/dev-api `头的请求地址。

```javascript
// .env.development
// 默认代理转发的请求前缀
VUE_APP_BASE_API = '/dev-api'
// 默认代理服务器地址
VUE_APP_PROXY_SERVER = 'http://47.103.46.222:9080'

// 网关登录相关配置
VUE_APP_ID = 'app-ui'
VUE_APP_REALMCODE = 'app'
// 授权登录跳转的路由地址， 开发环境下默认是VUE_APP_PROXY_SERVER + VUE_APP_AUTH_SERVICE
VUE_APP_AUTH_SERVICE = 'ldp-service/login'
```

```javascript
 // vue.config.js  vue代理转发配置
proxy: {
    // 请求代理的前缀路由地址
    [process.env.VUE_APP_BASE_API]: {
		// 目标服务器地址
        target: process.env.VUE_APP_PROXY_SERVER,
            changeOrigin: true,
            pathRewrite: {
                // 重写路由地址将process.env.VUE_APP_BASE_API 开头地址重写成''
                // 假设请求地址为/dev-api/mcs-service/user/userinfo
                // 也就是/dev-api开头地址的会自动转换为 'http://47.103.46.222:9080/mcs-service/user/userinfo' 进行代理请求
                 ['^' + process.env.VUE_APP_BASE_API]: ''
        }
    }
}
```

## 本地联调说明

> 通常情况下平台都需要登录才能进行接口访问， 也就是需要从授权登录页面获取到token，然后再进行操作， 那么就需要先配置 授权的相关信息。
> 如果只是服务器地址变化，则修改 `VUE_APP_PROXY_SERVER` 即可。
>
> 后端本地联调则需要进行路由转发配置， 假设后端访问的接口是`example-service/user/userinfo`

```javascript
// vue.config.js
/*
* 本地联调配置变量说明
* proxyLocalServer 本地联调的接口地址
*
* proxyLocalPath 代理转发的路由匹配地址
* 默认项目中使用`axios`封装的接口请求默认需要拼接上process.env.VUE_APP_BASE_API
*
* proxyLocalSecond 使用其他库请求接口或者静态资源的匹配地址
* 不需要拼接process.env.VUE_APP_BASE_API
* 
* rewriteTargetPath 重写的实际请求地址路径。如果需要跟路径地址转换则需要配置
* 如/api/user/userinfo 请求代理到的实际地址也是/api/user/userinfo
* 匹配的路径为/api 那么rewritePath 也需要设置为/api
*
*/
const proxyLocalServer = `http://192.168.0.106:8800`
const proxyLocalPath = process.env.VUE_APP_BASE_API + '/example-service'
const proxyLocalSecond =  '/example-service'
const rewriteTargetPath = ''
// 代理设置对象
proxy: {
    /**
    * 代理设置说明
    * 按照定义顺序依次进行匹配，如匹配到路径则进行转发操作。
    * 优先级高的匹配需要定义在前面。
    */
    // 第一种默认请求方式的代理转发
    proxyLocalPath: {
        target: proxyLocalServer,
        changeOrigin: true,
        pathRewrite: {
        	'^' + proxyLocalPath: rewriteTargetPath
        }
    },
    // 第二种用其他请求方式的代理转发
    proxyLocalSecond: {
        target: proxyLocalServer,
        changeOrigin: true,
        pathRewrite: {
        	'^' + proxyLocalSecond: rewriteTargetPath
        }
    },
    /**
    *保留默认配置请求，部分接口请求需要依赖服务器环境。
    */
     [process.env.VUE_APP_BASE_API]: {
        	target: process.env.VUE_APP_PROXY_SERVER,
            changeOrigin: true,
            pathRewrite: {
                 ['^' + process.env.VUE_APP_BASE_API]: ''
            }
     }
}

```

列举几个代理匹配的例子
> 重写匹配规则: `proxy`中的`target`参数 
>
> 重写值: `rewriteTargetPath`变量

| 前端请求地址       | 重写匹配规则 | 重写值 | 实际接口地址 |
| -------------------- | -------------------- | ---------------------------------- | ---------------------------------- |
| `/user/userinfo`     | `^/user`             | `'/user'`                          | `http:192.168.0.106:8800/user/userinfo` |
| `/api/user/userinfo` | `^/api`              | `''`                               | `http:192.168.0.106:8800/user/userinfo` |
| `/api/user/userinfo` | `^/api/user`         | `'/user'`                          | `http:192.168.0.106:8800/user/userinfo` |

