# 流程系统开发配置说明

流程系统配置文件说明：

```yml
ldp:
  flowable:
  	# 字体文件
    font-name: 宋体
    # BPM系统发起流程时，流程实例标题规则
    bpm-process-title-el-expression: '{#userName}发起{#processDefName}'
    # API发起流程时，流程实例标题规则
    api-process-title-el-expression: '{#userName}发起{#processDefName}'
    # 节点没有认领人，则跳过
    skip-approve-without-claim-user: true
    # 委派逻辑，协办人执行界面按钮是否需要隐藏
    hidden-button-when-task-delegate: true
```



## 一、流程实例标题规则

流程实例标题规则有两个`bpm-process-title-el-expression`、`api-process-title-el-expression`。在BPM系统中，通过页面发起流程时，读取`bpm-process-title-el-expression`，通过开发API接口发起流程则读取`api-process-title-el-expression`。

**1.1、 默认内置变量**

规则通过EL表达式读取变量来进行替换

| 变量名称          | 变量值       | 备注 |
| ----------------- | ------------ | ---- |
| {#userName}       | 当前用户名   |      |
| {#userAccount}    | 当前用户账号 |      |
| {#processDefName} | 流程定义名称 |      |

`bpm-process-title-el-expression` **只能使用这3个变量** 来组装流程实例 名称，例如：

```yml
申请人{#userName}发起{#processDefName}
{#userAccoun}发起流程{#processDefName}
```



**1.2 、API请求扩展外部变量**

`api-process-title-el-expression`除了内置变量以外，还可以通过传入流程变量来添加变量，举例，假如需要一个项目编码、项目名称：

调用方代码：

```java
//将项目编码、项目名称放入流程变量
Map<String, Object> processVariables = new HashMap<>();
processVariables.put("projectCode", projectCode);
processVariables.put("projectName", projectName);

//将流程变量设置到启动参数中
ProcessParam processParam = new ProcessParam();
processParam.setProcessVariables(processVariables);

// 这里省略一些其它代码
ProcessParam processParam = new ProcessParam();
processParam.setProcessVariables(processVariables);
processEngineService.start(formKey, businessKey, processParam)
```

`api-process-title-el-expression`就能使用内置变量和这两个流程变量一起来构建流程实例名称，例如：

```yml
申请人{#userName}发起的{#projectName}项目流程{#processDefName}
{#userName}发起流程项目编码{#projectCode}
```

这里假定userName为"张三"，项目名称为 "凤凰"，项目编码为"P001"，流程定义名称 ”资源协调“

根据上面两个规则分别生成的标题为：

1、申请人**张三**发起的**凤凰**项目流程**资源协调**

2、**张三**发起流程项目编码**P001**

