## LDP集中式安装部署说明

[TOC]

    此文档说明在单服务器下，集中式安装部署所有LDP服务；LDP依赖 mysql,redis等中间件服务，建议使用其它服务器独立安装部署。

## 服务器参数  
Server OS：CentOS Linux release 7.5+  
Mem：16G  
Core：8核  

## 运行环境准备

#### JRE 1.8+ (服务器版)

  安装包已提供 jre-8u251-linux-x64.tar.gz 需自行解压配置环境，过程略。

#### mysql

安装
```shell
## 配置源
vi /etc/yum.repos.d/mysql57-community.repo 
[mysql57-community]
name=MySQL 5.7 Community Server
baseurl=http://repo.mysql.com/yum/mysql-5.7-community/el/7/$basearch/
enabled=1
gpgcheck=0
gpgkey=file:///etc/pki/rpm-gpg/RPM-GPG-KEY-mysql
## 安装
yum repolist enabled | grep mysql
sudo yum install mysql-community-server
```

配置
```shell
## 加入大小写忽略配置
vi  /etc/my.cnf
lower_case_table_names=1
```
服务管理

```shell
## 启动，停止，状态
systemctl start mysqld
systemctl stop mysqld
systemctl status mysqld
```

#### redis 

安装

```shell
sudo yum install redis
```

配置

```shell
##配置文件，修改配置远程连接,端口，密码，如下
vi /etc/redis.conf
# bind 127.0.0.1 
port 7268
requirepass cacheForldp2020

```
服务管理

```shell
## 查看状态，启动，停止
sudo systemctl status redis
sudo systemctl start redis
sudo systemctl stop redis
```

#### nginx 1.12+ 

下载
```shell
wget http://downloads.sourceforge.net/project/pcre/pcre/8.35/pcre-8.35.tar.gz

wget http://nginx.org/download/nginx-1.13.6.tar.gz

```

安装

```shell
yum -y install make zlib zlib-devel gcc-c++ libtool openssl openssl-devel

tar -xvf pcre-8.35.tar.gz -C /usr/local
cd /usr/local/pcre-8.35/
./configure
make && make install

tar -xvf nginx-1.13.6.tar.gz -c /usr/local
cd nginx-1.13.6
./configure --prefix=/usr/local/nginx --with-http_stub_status_module --with-http_ssl_module --with-pcre=/usr/local/pcre-8.35 
make && make install
```

服务管理  

```shell 
cd /usr/local/nginx/sbin  
# 启动
./nginx 
# 停止 
./nginx -s stop  
```

#### nacos 

LDP安装包已集成。


## LDP安装说明


#### 安装包目录
```shell
├── bin
├── conf
│   ├── application.yml   #manage服务配置文件
│   ├── boot.conf         #启动配置文件，nacos地址和spring.profiles.active
│   ├── logback.xml       #manage服务日志配置文件
│   └── sinra_ldp_db.sql  #数据库初始化sql文件
├── extlib
├── fatjar
│   ├── base-startup-1.0-SNAPSHOT.jar  #基础服务jar包
│   ├── job-startup-1.0.38.jar         #job 服务jar包
│   ├── ldp-generator-1.0-SNAPSHOT.jar #自动生成代码服务包
│   ├── mcs-startup-1.0.38.jar         #mcs服务jar包
│   ├── service-gateway-1.0.38.jar     #网关服务jar包
│   └── uaa-startup-1.0.38.jar         #统一认证uaa服务jar包
├── jre-8u251-linux-x64.tar.gz   #jre压缩包
├── lib          #服务依赖jar包目录
├── logs         #日志目录
├── nacos        #naocs目录
│   ├── bin 
│   ├── conf
│   ├── data
│   ├── LICENSE
│   ├── logs
│   ├── NOTICE
│   └── target
├── tool                  
│   ├── base-boot.sh      #基础服务启动/关闭脚本
│   ├── gateway-boot.sh   #网关服务启动/关闭脚本
│   ├── generator-boot.sh #自动生成代码服务启动/关闭脚本
│   ├── job-boot.sh       #job服务启动/关闭脚本
│   ├── ldp-boot.sh       #统一启动关闭脚本，所有ldp服务可以通过此脚本一件启动和关闭
│   ├── manage-boot.sh    #manage服务启动/关闭脚本
│   ├── mcs-boot.sh       #mcs服务启动/关闭脚本
│   └── uaa-boot.sh       #uaa服务启动/关闭脚本
└── ui
    └── mcs   #mcs前端资源目录
```



#### 修改启动配置boot.conf

`conf/boot.conf`是和启动脚本配合使用的配置文件，内容如下：

```shell
NACOS_SERVER=nacos-server0:8018
SPRING_PROFILES_ACTIVE=nacos
DUBBO_PROTOCOL_HOST=sinra-server0
DEPLOY_ENV=prod
```

配置文件内容解释：

| key                    | 备注                                                         |
| ---------------------- | ------------------------------------------------------------ |
| NACOS_SERVER           | 指定服务注册的NACOS地址                                      |
| SPRING_PROFILES_ACTIVE | 指定启动的配置文件                                           |
| DUBBO_PROTOCOL_HOST    | DEPLOY_ENV值为`dev`时，指定以下服务在NACOS上的IP值（base-service、uaa-service、mcs-service、job-service） |
| DEPLOY_ENV             | 指定启动环境(prod、dev)，当启动环境为prod的时候，服务在NACOS上的值默认为IP |

根据部署环境修改配置文件

**开发环境：**

1、修改`DUBBO_PROTOCOL_HOST`为对应的值（需要在hosts中配置）

2、修改`DEPLOY_ENV`为`dev`

**生产环境：**

不用做任何修改。



#### 中间件服务hosts配置

在服务器host配置中加入以下配置，根据实际服务修改相应ip

```shell
# mysql 数据库服务
127.0.0.1 mysql-server0
# redis 服务
127.0.0.1 redis-server0
# nacos 服务
127.0.0.1 nacos-server0

# 网关服务
127.0.0.1 gateway-server0
# ldp 服务
127.0.0.1 ldp-server0
```

#### 新建数据库

- 在mysql内创建ldp数据库: sinra_ldp_db ，字符集：utf8mb4


####  nacos 启动 & 访问

```shell
# 启动
cd nacos/bin
./startup.sh -m standalone
 
```

访问地址：http://nacos-server0:8018/nacos   

默认用户名/口令： nacos/nacos


### nacos在线配置参数

#### 数据库参数配置   

 * 进入nacos配置列表
	 	![nacos配置列表](imgs/nacos-config-list.png)
  * 修改base-server-nacos.yml
     ![base-server-nacos.yml](imgs/base-server-nacos-config-list.png)
  * 修改如图所示的用户名及密码
     ![base-server-nacos.yml](imgs/base-server-nacos-config-list-change.png)
  * 修改后保存即可

#### redis 参数配置   

* 进入nacos配置列表
	 	![nacos配置列表](imgs/nacos-config-list.png)
* 修改 mcs-service-nacos.yml、uaa-service-nacos.yml和job-service-nacos.yml
	 ![redis-change-list.png](imgs/redis-change-list.png)
*  修改如图所示的密码或端口
	![redis-change-1.png](imgs/redis-change-1.png)
   ![redis-change-2.png](imgs/redis-change-2.png)

* 修改后保存即可

### 启动 ldp 服务

```shell
# 启动
cd tool/
./ldp-boot.sh start
```
脚本会依次启动base-service（基础服务）、job-service（定时任务服务）、mcs-service（mcs服务）、uaa-service（统一认证服务）、gateway-service（网关服务）、generator（代码生成服务）、service-manage（管理服务）。

基础服务启动时会执行sql对数据库进行初始化，由于mcs、job、uaa等服务启动时依赖基础服务，所以这里会先等基础服务启动完成才会执行其它服务的启动。

可以通过查看status来确认服务是否正常启动

```shell
# 查看服务状态
./ldp-boot.sh status
```

也可以访问地址：http://nacos-server0:8018/nacos

点击服务列表，即可看到以启动并注册的服务信息。如下图：

![nacos服务列表](imgs/nacos-service.png)

如果服务启动失败查看logs/目录下相应的日志文件

### 启动 ldp web 服务

ldp mcs ui 发布

```shell
# 复制mcs 到 nginx/html 目录
cp -r ui/mcs /usr/local/nginx/html/ 

```

nginx 配置

```shell
vim /usr/local/nginx/conf/nginx.conf
```

```shell

# 配置nginx 服务代理，参考如下

    upstream ldpserver {

        # 关键配置，网关服务地址
        server gateway-server0:9000 weight=1;
    }
 
    server {
        listen       9080;
        server_name  localhost;

        #charset koi8-r;

        #access_log  logs/host.access.log  main;

        location / {
            root   html;
            index  index.html index.htm;
        }

        #error_page  404              /404.html;

        # redirect server error pages to the static page /50x.html
        #
        error_page   500 502 503 504  /50x.html;
        location = /50x.html {
            root   html;
        }

        # proxy the PHP scripts to Apache listening on 127.0.0.1:80
        #
        #location ~ \.php$ {
        #    proxy_pass   http://127.0.0.1;
        #}
        #

        # 必需配置
        location /genservice {

             rewrite ^/(genservice.*) /$1 break;
             proxy_pass http://127.0.0.1:8600;
             proxy_set_header Host $host;
             proxy_set_header X-Real-Ip $remote_addr;
             proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
             proxy_set_header X-Forwarded-Proto  $scheme;
         }

         # 必需配置
         location ~* /.*-service/ {

             rewrite ^/(.*-service.*) /$1 break;
             proxy_pass http://ldpserver;

             proxy_set_header Host $host;
             proxy_set_header X-Real-Ip $remote_addr;
             proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
             ## 代理设置 https
             proxy_set_header X-Forwarded-Proto  $scheme;
         }
    }


```


启动web 服务

```shell
cd /usr/local/nginx/sbin/
## 启动服务 
./nginx

```

访问mcs-ui地址：

http://服务域名或ip:9080/mcs

![mcs登录界面](imgs/login.png)

初始用户名：admin
初始密码：1234561
