package com.cftech.sys.controller;

import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.JsonDateValueProcessor;
import com.cftech.sys.model.Log;
import com.cftech.sys.param.SysLogListParam;
import com.cftech.sys.security.PermissionSign;
import com.cftech.sys.security.UserUtils;
import com.cftech.sys.service.LogService;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/** 
 * @author 作者 lisw: 
 * @version 创建时间：2016年10月24日 下午1:34:10 
 * 后台日志操作Controller
 */
@Controller
@RequestMapping("/a/syslog")
public class SysLogController {
	
	@Autowired
	private LogService logService;
	
	@RequestMapping(value="/list",method=RequestMethod.GET)
	@RequiresPermissions(value = PermissionSign.SYSLOG_VIEWS)
	public String sysLogList(HttpServletRequest request,SysLogListParam sysLogListParam,Model model){
		model.addAttribute("sysLogListParam",sysLogListParam);
		return "managerlog/sysloglist";
	}
	
	@RequestMapping(value="/fetchData",method=RequestMethod.POST)
	@RequiresPermissions(value = PermissionSign.SYSLOG_VIEWS)
	@ResponseBody
	public JSONObject fetchData(int iDisplayStart, int iDisplayLength,
								Log log, SysLogListParam sysLogListParam, HttpServletRequest request){
		Sort sort = new Sort("t.create_date", OrderType.DESC);
		Conds conds = new Conds();
		conds.equal("appid", UserUtils.getmpaccounts(request).toString());
		//请求参数
		if(sysLogListParam != null){
			if(StringUtils.isNoneBlank(sysLogListParam.getBrithdayStarttime()) && StringUtils.isNoneBlank(sysLogListParam.getBrithdayEndtime())){
				conds.between("t.create_date", sysLogListParam.getBrithdayStarttime(),sysLogListParam.getBrithdayEndtime());
			}else if(StringUtils.isNoneBlank(sysLogListParam.getBrithdayStarttime())){
				conds.greatEqual("t.create_date",sysLogListParam.getBrithdayStarttime());
			}else if(StringUtils.isNoneBlank(sysLogListParam.getBrithdayEndtime())){
				conds.lessEqual("t.create_date",sysLogListParam.getBrithdayEndtime());
			}
			if(StringUtils.isNoneBlank(sysLogListParam.getName())){
				conds.like("u.username",sysLogListParam.getName());
			}
		}
		// 获取列表数据
		List<Log> activityList = logService.fetchSearchByPageSysUser(conds, sort, iDisplayStart, iDisplayLength);
		// 获得总数
		Integer userCounts = logService.countSysUser(conds);
		JSONObject rtnJson = new JSONObject();
		rtnJson.put("iTotalRecords", userCounts);
		rtnJson.put("iTotalDisplayRecords", userCounts);
		JsonConfig jsonConfig = new JsonConfig();
		jsonConfig.registerJsonValueProcessor(java.sql.Date.class,
				new JsonDateValueProcessor("yyyy-MM-dd HH:mm:ss"));
		rtnJson.put("aaData", JSONArray.fromObject(activityList, jsonConfig));
		return rtnJson;
	}
}
 