package com.cftech.common.supplier.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.common.manager.model.Manager;
import com.cftech.common.manager.model.ManagerDto;
import com.cftech.common.manager.service.ManagerService;
import com.cftech.common.supplier.model.Supplier;
import com.cftech.common.supplier.model.SupplierDto;
import com.cftech.common.supplier.service.SupplierService;
import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.List;


/**
 * 通用申请单管理员配置Controller
 * <p>
 * 权限字符串说明:
 * 查看:public static final String MANAGER_VIEW = "qy:manager:view"
 * 查看:public static final String MANAGER_EDIT = "qy:manager:edit"
 *
 * @author faye
 * @date: 2019-08-14 17:21
 */
@Slf4j
@Controller
@RequestMapping("/a/supplier")
public class SupplierController {

    public static final String SUPPLIER_EDIT = "qy:typeAppForm:dis:edit";

    @Autowired
    private SupplierService supplierService;




    //编辑页面（新增、修改）
    @RequiresPermissions(value = SUPPLIER_EDIT)
    @RequestMapping("/form")
    public String form(HttpServletRequest request, String id, Model model,Long typeform) {
            Supplier     supplier = supplierService.fetchById(id);
            model.addAttribute("data", supplier);
        if(StringUtils.isEmpty(typeform)){
            typeform=1L;
        }
        model.addAttribute("typeform", typeform);
            List<SupplierDto> supplierDtos = supplierService.fetchOpenidNickName(typeform);
            if(supplierDtos!=null && supplierDtos.size()>0){
                String openIds = "";
                String nickNames = "";
                for(SupplierDto supplierDto : supplierDtos){
                    openIds+=supplierDto.getOpenid()+",";
                    nickNames+=supplierDto.getNickname()+",";
                }
                model.addAttribute("nickNames",nickNames);
                model.addAttribute("openids",openIds);
                model.addAttribute("fanssArray",supplierDtos);
            }

        return "supplier/supplierform";
    }

    //提交数据（新增、修改）
    @RequiresPermissions(value = SUPPLIER_EDIT)
    @RequestMapping("/formData")
    @ResponseBody
    public JSONObject formData(Manager manager, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("errorNo", 0);
        try {
            String [] ids = null;
            if(manager!=null && !StringUtils.isEmpty(manager.getOpenid())){
                ids = manager.getOpenid().split(",");
            }
            supplierService.emptyTable(ids,UserUtils.getUser().getId(),accountsId,manager.getTypeform());
        } catch (Exception e) {
            e.printStackTrace();
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }


}
