package com.cftech.brand.apply.detail.service.impl;

import com.cftech.brand.apply.detail.model.BrandApplyDetail;
import com.cftech.brand.apply.detail.dao.BrandApplyDetailMapper;
import com.cftech.brand.apply.detail.model.BrandApplyDetailVo;
import com.cftech.brand.apply.detail.service.BrandApplyDetailService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.List;

/**
* 品牌申请详情ServiceImpl
*
* @author faye
* @date 2020/01/15
*/
@Service("brandApplyDetailService")
public class BrandApplyDetailServiceImpl extends GenericServiceImpl<BrandApplyDetail> implements BrandApplyDetailService {

@Autowired
@Qualifier("brandApplyDetailMapper")
private BrandApplyDetailMapper brandApplyDetailMapper;

@Override
public GenericDao<BrandApplyDetail> getGenericMapper() {
return brandApplyDetailMapper;
}

    @Override
    public List<BrandApplyDetailVo> getDatabyApplyId(Long applyId) {
        return brandApplyDetailMapper.getDatabyApplyId(applyId);
    }
}