package com.cftech.questionnaire.core.paper.service.impl;

import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.questionnaire.core.paper.dao.PaperLogMapper;
import com.cftech.questionnaire.core.paper.model.PaperAnswer;
import com.cftech.questionnaire.core.paper.model.PaperLog;
import com.cftech.questionnaire.core.paper.model.PaperLogDto;
import com.cftech.questionnaire.core.paper.service.PaperLogService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 问卷记录ServiceImpl
 *
 * @author wxf
 * @date: 2017-05-25 10:27
 */
@Service("paperLogService")
public class PaperLogServiceImpl extends GenericServiceImpl<PaperLog> implements PaperLogService {

    @Autowired
    @Qualifier("paperLogMapper")
    private PaperLogMapper paperMapper;

    @Override
    public GenericDao<PaperLog> getGenericMapper() {
        return paperMapper;
    }


    @Override
    public List<PaperLogDto> fetchPaperLogList(Conds conds, int page, int pageSize, Sort sort) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return paperMapper.fetchPaperLogList(params);
    }

    @Override
    public Integer fetchPaperLogListCount(Conds conds) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        return paperMapper.fetchPaperLogListCount(params);
    }

    @Override
    public  List<PaperAnswer> searchpaperanswer (Conds conds,Long paperId){
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("paperId", paperId);
        return  paperMapper.searchpaperanswer(params);
    }
}