package org.mp.api.core.req.model;

import com.cftech.cos.config.cosconfig.model.Cosconfig;
import lombok.Data;
import org.mp.api.core.annotation.ReqType;

/**
 * 下载多媒体文件
 * 
 * @author sfli.sir
 * 
 */
@ReqType("mediaget")
@Data
public class DownloadMedia extends WeixinReqParam {

	/**
	 * 媒体信息id
	 */
	private String media_id;
	/**
	 * 下载存储的文件目录
	 */
	private String filePath;
	
	/**
	 * 文件前缀
	 * @return
	 */
	private String prefix;
	
	/**
	 * 是下载到本地一个路径还是下载之后直接上传到云盘（七牛云或腾讯云）
	 * @return
	 */
	private String istrue;

	/**
	 * 上传配置
	 * @return
	 */
	private Cosconfig cosconfig;

	/**
	 *公众号ID
	 */
	private Long accountsId;

	
	


}
