package com.cftech.mp.reply.service.impl;

import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.mp.reply.dao.ReplyMapper;
import com.cftech.mp.reply.model.Reply;
import com.cftech.mp.reply.service.ReplyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * replyService
 * Created by lisw 27/10/2016.
 */
@Service("replyService")
public class ReplyServiceImpl extends GenericServiceImpl<Reply> implements ReplyService {

	/**
	 * replyMapper
	 */
	@Autowired
	@Qualifier("replyMapper")
	private ReplyMapper replyMapper;

	@Override
	public GenericDao<Reply> getGenericMapper() {
		return replyMapper;
	}


	@Override
	public List<Reply> fetchkeywordByPage(String keyword,Long accountsId,String replyType) {
		Map<String,Object> params = new HashMap<String,Object>();
		params.put("keyword",keyword);
		params.put("accountsid",accountsId);
		params.put("send_type",replyType);
		return replyMapper.fetchkeywordByPage(params);
	}

	@Override
	public String getOpenId(String unionid) {
		return replyMapper.getOpenId(unionid);
	}
}
