package com.cftech.mp.fans.controller;


import com.alibaba.fastjson.JSONObject;
import com.cftech.accounts.service.MpAccountsService;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.StringUtils;
import com.cftech.mp.fans.model.Fanssgroup;
import com.cftech.mp.fans.model.FanssgroupDto;
import com.cftech.mp.fans.service.FanssgroupService;
import com.cftech.sys.security.UserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 管理粉丝分类 Date: 2016-012-30 15:28
 * 
 * @author mubo
 *
 */
@Controller
@RequestMapping(value = "/a/fanssgroup")
public class FanssgroupController {

	private static Logger logger = LoggerFactory
			.getLogger(FanssgroupController.class);

	@Autowired
	private FanssgroupService fanssgroupService;
	@Autowired
	private MpAccountsService mpAccountService;

	//粉丝分组列表页面
	@RequestMapping(value = "/list",method = {RequestMethod.POST,RequestMethod.GET})
	public String list(HttpServletRequest request,
			HttpServletResponse response,FanssgroupDto fd,Model model){
			model.addAttribute("params",fd);
				return "fanssgroup/fanssgrouplist";
	}
	
	@RequestMapping(value = "/fetchdata",method = {RequestMethod.POST,RequestMethod.GET})
	@ResponseBody
	public JSONObject getUsers(int iDisplayStart, int iDisplayLength,
			HttpServletResponse response, HttpServletRequest request,
			FanssgroupDto fanssgroupDto, String startTime, String endTime) {
		Long accountsid = UserUtils.getmpaccounts(request);
 		JSONObject result = new JSONObject();

		Sort sort = new Sort("createtime", OrderType.DESC);
		Conds conds = new Conds();
		conds.equal("delflag", "0");
		conds.equal("accountsid",accountsid);
		if (StringUtils.isNotBlank(fanssgroupDto.getName())){
			conds.like("name", fanssgroupDto.getName());
		}
		// 获取列表
		List<Fanssgroup> list = fanssgroupService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
		// 获得总数
		int recCount = fanssgroupService.count(conds);
		result.put("iTotalRecords", recCount);
		result.put("iTotalDisplayRecords", recCount);
//		JsonConfig jsonConfig = new JsonConfig();
//		jsonConfig.registerJsonValueProcessor(java.sql.Timestamp.class,
//				new JsonDateValueProcessor("yyyy-MM-dd HH:mm:ss"));
//		result.put("aaData", JSONArray.fromObject(list, jsonConfig)  );
		result.put("aaData",list);
		return result;
	}
	
	// 添加粉丝类型跳转页面
	@RequestMapping(value = "/toadd",method = {RequestMethod.POST,RequestMethod.GET})
	public String toadd(HttpServletRequest request,
			HttpServletResponse response, Model model, Long id) {
		return "/fanssgroup/fanssgroupadd"; 
	}
	// 修改粉丝类型跳转页面
	@RequestMapping(value = "/toupdate",method = {RequestMethod.POST,RequestMethod.GET})
	public String toupdate(HttpServletRequest request,
			HttpServletResponse response, Model model, Long id) {
		if (null != id) {
			// 获得单条积分信息
			Fanssgroup fanssgroup = fanssgroupService.fetchById(id);
			model.addAttribute("params", fanssgroup);
		}
		return "/fanssgroup/fanssgroupupdate"; 
	}
	//添加
	@RequestMapping(value = "/add",method = {RequestMethod.POST})
	@ResponseBody
	public JSONObject addsubmit(HttpServletRequest request,
			HttpServletResponse response, Model model,Fanssgroup fanssgroup){
		JSONObject result = new JSONObject();
		result.put("errorNo",1);
		Long accountsid = UserUtils.getmpaccounts(request);
		fanssgroup.setAccountsid(accountsid);
		fanssgroup.setCreateby(UserUtils.getUser().getId());
		fanssgroup.setUpdateby(UserUtils.getUser().getId());
		fanssgroup.setDelflag("0");
		try {
			Boolean res=fanssgroupService.savelabel(fanssgroup,accountsid);
			if(res){
				result.put("errorNo",0);
			}
		} catch (Exception e) {
			e.printStackTrace();
			result.put("errorNo",1);
		}
		return result; 
	}
	//修改
	@RequestMapping(value = "/update",method = {RequestMethod.POST})
	@ResponseBody
	public JSONObject updatesubmit(HttpServletRequest request,
			HttpServletResponse response, Model model,Fanssgroup fanssgroup){
		JSONObject result = new JSONObject();
		result.put("errorNo",1);
		Conds conds =new Conds();
		String name = fanssgroup.getName();
		
		conds.equal("id", fanssgroup.getId());
		fanssgroup=fanssgroupService.fetchSearchByConds(conds);
		fanssgroup.setName(name);
		try {
			Boolean res=fanssgroupService.updatelabel(fanssgroup,UserUtils.getmpaccounts(request));
			if(res){
				result.put("errorNo",0);
			}
		} catch (Exception e) {
			result.put("errorNo",1);
		}
		return result; 
	}
	//删除
	@RequestMapping(value = "/delete",method = {RequestMethod.POST})
	@ResponseBody
	public JSONObject delete(HttpServletRequest request,
			HttpServletResponse response, Model model,Fanssgroup fanssgroup){
		JSONObject result = new JSONObject();
		Conds conds =new Conds();
		conds.equal("id", fanssgroup.getId());
		fanssgroup=fanssgroupService.fetchSearchByConds(conds);
		result.put("errorNo",1);
		try {
			if(fanssgroup.getId()!=null){
				Boolean res=fanssgroupService.deletelabel(fanssgroup,UserUtils.getmpaccounts(request));
				if(res){
					result.put("errorNo",0);
				}
			}
		} catch (Exception e) {
			result.put("errorNo",1);
		}
		return result; 
	}
	
}
