package com.cftech.activity.eggs.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.activity.eggs.model.Eggs;
import com.cftech.activity.eggs.service.EggsService;
import com.cftech.activity.log.model.EggsLog;
import com.cftech.activity.log.service.EggsLogService;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.DateFormatUtils;
import com.cftech.questionnaire.core.paper.model.PaperBaseEntity;
import com.cftech.questionnaire.core.paper.model.PaperLog;
import com.cftech.questionnaire.core.paper.service.PaperLogService;
import com.cftech.questionnaire.core.paper.service.PaperService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.HtmlUtils;

import java.util.Date;
import java.util.List;

/**
 * 手机端大转盘接口
 * @author wuxf
 * @version 2017-04-27
 */
@RestController
@RequestMapping("/mobile/auth/activity/eggs")
@Slf4j
public class MobileEggsController {

    @Autowired
    private EggsService eggsService;

    @Autowired
    private EggsLogService eggsLogService;

    @Autowired
    private PaperService paperService;

    @Autowired
    private PaperLogService paperLogService;

    /**
     * 获取砸金蛋活动详情接口
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/detail/{id}/{openId}", method = {RequestMethod.GET,RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject detail(@PathVariable("id") Long id,@PathVariable("openId") String openId) {

        JSONObject rtnJson = new JSONObject();

        try {
            Eggs eggs = eggsService.fetchById(id);
            Conds conds = new Conds();
            conds.equal("open_id",openId);
            conds.equal("activity_id",id);
            int count=eggsLogService.count(conds);
            if(eggs!=null){
                eggs.setPlayCount(count);
                conds.equal("date(t.create_time)", DateFormatUtils.getDateFormat(new Date(),"yyyy-MM-dd"));
                int nowCount=eggsLogService.count(conds);
                eggs.setNowPlayCount(nowCount);
            }
            rtnJson.put("errorNo", 0);
            rtnJson.put("data", eggs);

        } catch (Exception e) {
            log.error("获取活动详情出现异常:" + e.getMessage());
            rtnJson.put("errorNo", 1);
        }

        return rtnJson;
    }

    @RequestMapping(value = "/play/{id}/{openId}", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject play(@PathVariable("id") Long id, @PathVariable("openId") String openId , Long meetingId) {
        JSONObject rtnJson = new JSONObject();
        try {
            Conds conds = new Conds();
            conds.equal("activity_type",0);
            conds.equal("activity_id",id);
            conds.equal("del_flag",0);
            Sort sort = new Sort("create_time", OrderType.DESC);
            List<PaperBaseEntity> list = paperService.fetchSearchByPage(conds,sort,0,0);
            if(list!=null && list.size()>0){   //该活动已经绑定问卷
                Conds condslog = new Conds();
                condslog.equal("palyer_id",openId);
                condslog.equal("del_flag",0);
                Sort sortlog = new Sort("create_time",OrderType.DESC);
                List<PaperLog> listlog = paperLogService.fetchSearchByPage(condslog,sortlog,0,0);
                if(listlog==null || listlog.size()==0){  //改玩家没填问卷
                    rtnJson.put("errorNo",6);  //没有填问卷不能玩
                    return rtnJson;
                }
            }
            Eggs eggs = eggsService.fetchById(id);
            eggs.setPrizes(HtmlUtils.htmlUnescape(eggs.getPrizes()));
            eggs.setMeetingId(meetingId);
            rtnJson = eggsService.play(openId,eggs);
            if(!rtnJson.getString("errorNo").equals("1")) {
                EggsLog eggsLog = new EggsLog();
                eggsLog.setDelFlag(false);
                eggsLog.setAccountsId(eggs.getAccountsId());
                eggsLog.setActivityId(eggs.getId());
                eggsLog.setFrom(eggs.getClass().getSimpleName());
                eggsLog.setOpenId(openId);
                eggsLog.setTitle(eggs.getTitle());
                if(meetingId!=null){
                    eggsLog.setDescription(meetingId.toString());
                }
                eggsLogService.save(eggsLog);
            }
        } catch (Exception e) {
            e.printStackTrace();
            rtnJson.put("errorNo",1);
            log.error("玩游戏出现异常:" + e.getMessage());
        }
        return rtnJson;
    }

}
